/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.exception;

public class RestOperationException
extends RuntimeException {
    private static final long serialVersionUID = 3065096836333886139L;
    protected Integer status = null;

    public RestOperationException(String s) {
        super(s);
    }

    protected RestOperationException(String s, Status status) {
        super(s);
        this.status = status.getValue();
    }

    public RestOperationException(String s, Throwable throwable) {
        super(s, throwable);
    }

    protected RestOperationException(String s, Throwable throwable, Status status) {
        super(s, throwable);
        this.status = status.getValue();
    }

    public int getStatus() {
        return this.status;
    }

    public static RestOperationException badRequest(String msg) {
        return new RestOperationException(msg, Status.BAD_REQUEST);
    }

    public static RestOperationException forbidden(String msg) {
        return new RestOperationException(msg, Status.FORBIDDEN);
    }

    public static RestOperationException conflict(String msg, Exception e) {
        return new RestOperationException(msg, e, Status.CONFLICT);
    }

    public static RestOperationException notFound(String msg) {
        return new RestOperationException(msg, Status.NOT_FOUND);
    }

    public static RestOperationException internalServerError(String msg) {
        return new RestOperationException(msg, Status.INTERNAL_SERVER_ERROR);
    }

    public static RestOperationException internalServerError(String msg, Exception e) {
        return new RestOperationException(msg, e, Status.INTERNAL_SERVER_ERROR);
    }

    public static enum Status {
        BAD_REQUEST(400),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        INTERNAL_SERVER_ERROR(500),
        METHOD_NOT_ALLOWED(405),
        GONE(410),
        PRE_CONDITION_FAILED(412),
        NOT_ACCEPTABLE(406),
        UNSUPPORTED_MEDIA_TYPE(415),
        UNAUTHORIZED(401);

        private final int status;

        private Status(int s) {
            this.status = s;
        }

        public int getValue() {
            return this.status;
        }
    }
}

