/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.jaxb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbLongListResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbOtherResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPrimitiveResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbContentResponse;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskResponse;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;
import org.kie.services.remote.cdi.DeploymentInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicJAXBContext
extends JAXBContext {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJAXBContext.class);
    private Set<Class<?>> types = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, JAXBContext> contexts = new ConcurrentHashMap();
    @Inject
    private DeploymentInfoBean deploymentClassNameBean;
    private UriInfo uriInfo;

    public DynamicJAXBContext() {
        this.types.add(JaxbCommandsRequest.class);
        this.types.add(JaxbCommandsResponse.class);
        this.types.add(JaxbContentResponse.class);
        this.types.add(JaxbTaskResponse.class);
        this.types.add(JaxbTaskSummaryListResponse.class);
        this.types.add(JaxbProcessInstanceListResponse.class);
        this.types.add(JaxbProcessInstanceResponse.class);
        this.types.add(JaxbProcessInstanceWithVariablesResponse.class);
        this.types.add(JaxbWorkItem.class);
        this.types.add(JaxbDeploymentJobResult.class);
        this.types.add(JaxbDeploymentUnit.class);
        this.types.add(JaxbDeploymentUnitList.class);
        this.types.add(JaxbHistoryLogList.class);
        this.types.add(JaxbNodeInstanceLog.class);
        this.types.add(JaxbProcessInstanceLog.class);
        this.types.add(JaxbVariableInstanceLog.class);
        this.types.add(JaxbLongListResponse.class);
        this.types.add(JaxbOtherResponse.class);
        this.types.add(JaxbPrimitiveResponse.class);
        this.types.add(JaxbVariablesResponse.class);
        this.types.add(JaxbExceptionResponse.class);
        this.types.add(JaxbGenericResponse.class);
        this.types.add(JaxbRequestStatus.class);
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createUnmarshaller();
        }
        return null;
    }

    public Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createMarshaller();
        }
        return null;
    }

    public Validator createValidator() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createValidator();
        }
        return null;
    }

    public void addType(Class<?> type) {
        if (!this.types.contains(type)) {
            this.types.add(type);
            this.contexts.clear();
        }
    }

    public JAXBContext getContext() {
        HashSet classesForSerialization = new HashSet();
        classesForSerialization.addAll(JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET);
        classesForSerialization.addAll(this.types);
        String deploymentId = this.getDeploymentId();
        if (deploymentId == null) {
            logger.debug("Unable to find deployment id which results in returning default JAXBContext");
            try {
                Class[] types = classesForSerialization.toArray(new Class[classesForSerialization.size()]);
                return JAXBContext.newInstance((Class[])types);
            }
            catch (JAXBException e) {
                throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", e);
            }
        }
        ConcurrentHashMap<String, JAXBContext> concurrentHashMap = this.contexts;
        synchronized (concurrentHashMap) {
            if (this.contexts.containsKey(deploymentId)) {
                return this.contexts.get(deploymentId);
            }
            if (deploymentId != null) {
                Collection<Class<?>> deploymentClassNames = this.deploymentClassNameBean.getDeploymentClasses(deploymentId);
                for (Class<?> clazz : deploymentClassNames) {
                    logger.debug("Adding {} to JAXBContext instance.", (Object)clazz.getName());
                }
                classesForSerialization.addAll(deploymentClassNames);
            }
            Class[] types = classesForSerialization.toArray(new Class[classesForSerialization.size()]);
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])types);
                this.contexts.put(deploymentId, context);
                return context;
            }
            catch (JAXBException jaxbe) {
                throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", jaxbe);
            }
        }
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        this.contexts.remove(event.getDeploymentId());
    }

    protected String getDeploymentId() {
        String deploymentId = null;
        List deploymentIdParams = (List)this.uriInfo.getPathParameters().get((Object)"deploymentId");
        if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
            deploymentId = (String)deploymentIdParams.get(0);
        } else {
            deploymentIdParams = (List)this.uriInfo.getQueryParameters().get((Object)"deploymentId");
            if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
                deploymentId = (String)deploymentIdParams.get(0);
            }
        }
        return deploymentId;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }
}

