/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.cdi;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTaskContentCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.exception.DeploymentNotFoundException;
import org.kie.remote.services.exception.KieRemoteServicesRuntimeException;
import org.kie.remote.services.util.ExecuteAndSerializeCommand;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;
import org.kie.services.shared.AcceptedCommands;
import org.kie.workbench.common.services.rest.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcessRequestBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRequestBean.class);
    @Inject
    private DeploymentInfoBean runtimeMgrMgr;
    @Inject
    private TaskService injectedTaskService;
    private static final String PERSISTENCE_UNIT_NAME = "org.jbpm.domain";
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private AuditLogService auditLogService;

    public void setRuntimeMgrMgr(DeploymentInfoBean runtimeMgrMgr) {
        this.runtimeMgrMgr = runtimeMgrMgr;
    }

    public void setInjectedTaskService(TaskService taskService) {
        this.injectedTaskService = taskService;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @PostConstruct
    public void initAuditLogService() {
        this.auditLogService = new JPAAuditLogService(this.emf);
        if (this.emf == null) {
            ((JPAAuditLogService)this.auditLogService).setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        }
    }

    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    public void processCommand(Command cmd, JaxbCommandsRequest request, int i, JaxbCommandsResponse jaxbResponse) {
        String version = request.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.1.0.1")) {
            logger.warn("Request received from client version [{}] while server is version [{}]! THIS MAY CAUSE PROBLEMS!", (Object)version, (Object)"6.1.0.1");
        }
        String cmdName = cmd.getClass().getSimpleName();
        logger.debug("Processing command " + cmdName);
        String errMsg = "Unable to execute " + cmdName + "/" + i;
        Object cmdResult = null;
        try {
            if (cmd instanceof TaskCommand) {
                TaskCommand taskCmd = (TaskCommand)cmd;
                cmdResult = this.doTaskOperation(taskCmd.getTaskId(), request.getDeploymentId(), request.getProcessInstanceId(), null, taskCmd);
            } else if (cmd instanceof AuditCommand) {
                AuditCommand auditCmd = (AuditCommand)cmd;
                auditCmd.setAuditLogService(this.getAuditLogService());
                cmdResult = auditCmd.execute(null);
            } else {
                cmdResult = this.doKieSessionOperation(cmd, request.getDeploymentId(), request.getProcessInstanceId());
            }
        }
        catch (PermissionDeniedException pde) {
            logger.warn(errMsg, (Throwable)pde);
            jaxbResponse.addException((Exception)((Object)pde), i, cmd, JaxbRequestStatus.PERMISSIONS_CONFLICT);
        }
        catch (Exception e) {
            logger.warn(errMsg, (Throwable)e);
            jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
        }
        if (cmdResult != null) {
            try {
                jaxbResponse.addResult(cmdResult, i, cmd);
            }
            catch (Exception e) {
                errMsg = "Unable to add result from " + cmdName + "/" + i;
                logger.error(errMsg, (Throwable)e);
                jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId) {
        if (deploymentId == null) {
            throw new DeploymentNotFoundException("No deployment id supplied! Could not retrieve runtime to execute " + cmd.getClass().getSimpleName());
        }
        Object result = null;
        RuntimeEngine runtimeEngine = null;
        try {
            runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            result = kieSession.execute(cmd);
        }
        finally {
            this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
        }
        return result;
    }

    public Object getVariableObjectInstanceFromRuntime(String deploymentId, long processInstanceId, String varName) {
        String errorMsg = "Unable to retrieve variable '" + varName + "' from process instance " + processInstanceId;
        Object procVar = null;
        RuntimeEngine runtimeEngine = null;
        try {
            runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            ProcessInstance procInst = kieSession.getProcessInstance(processInstanceId);
            if (procInst == null) {
                throw RestOperationException.notFound((String)("Process instance " + processInstanceId + " could not be found!"));
            }
            procVar = ((WorkflowProcessInstanceImpl)procInst).getVariable(varName);
            if (procVar == null) {
                throw RestOperationException.notFound((String)("Variable " + varName + " does not exist in process instance " + processInstanceId + "!"));
            }
        }
        catch (RuntimeException re) {
            try {
                throw RestOperationException.internalServerError((String)errorMsg, (Exception)re);
            }
            catch (Throwable throwable) {
                this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
                throw throwable;
            }
        }
        this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
        return procVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<?> cmd) {
        boolean onDeployment = false;
        if (AcceptedCommands.TASK_COMMANDS_THAT_INFLUENCE_KIESESSION.contains(((Object)((Object)cmd)).getClass())) {
            onDeployment = true;
        }
        if (cmd instanceof GetTaskCommand || cmd instanceof GetContentCommand || cmd instanceof GetTaskContentCommand) {
            cmd = new ExecuteAndSerializeCommand(cmd);
        }
        if (!onDeployment) {
            return ((InternalTaskService)this.injectedTaskService).execute((Command)cmd);
        }
        if (task == null && deploymentId == null) {
            if (taskId == null) {
                throw new KieRemoteServicesRuntimeException("A task id should be available at this point! Please contact the developers.");
            }
            if (task == null) {
                task = this.injectedTaskService.getTaskById(taskId.longValue());
            }
            if (task == null) {
                throw new KieRemoteServicesRuntimeException("Task " + taskId + " does not exist!");
            }
            deploymentId = task.getTaskData().getDeploymentId();
            if (processInstanceId == null) {
                processInstanceId = task.getTaskData().getProcessInstanceId();
            }
        }
        if (deploymentId == null) {
            return ((InternalTaskService)this.injectedTaskService).execute((Command)cmd);
        }
        RuntimeEngine runtimeEngine = null;
        try {
            runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            if (runtimeEngine == null) {
                throw new DeploymentNotFoundException("Unable to find deployment '" + deploymentId + "' when executing " + ((Object)((Object)cmd)).getClass().getSimpleName());
            }
            TaskService runtimeTaskService = runtimeEngine.getTaskService();
            Object object = ((InternalTaskService)runtimeTaskService).execute((Command)cmd);
            return object;
        }
        finally {
            this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
        }
    }

    public Object doRestTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<?> cmd) {
        try {
            return this.doTaskOperation(taskId, deploymentId, processInstanceId, task, cmd);
        }
        catch (PermissionDeniedException pde) {
            throw RestOperationException.conflict((String)pde.getMessage(), (Exception)((Object)pde));
        }
        catch (RuntimeException re) {
            throw re;
        }
    }
}

