/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.async.cmd.DeploymentCmd;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.workbench.common.services.rest.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deployment/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class DeploymentResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request restRequest;
    @PathParam(value="deploymentId")
    private String deploymentId;
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private ExecutorService jobExecutor;

    protected KModuleDeploymentUnit createDeploymentUnit(String deploymentId, DeploymentDescriptorImpl descriptor) {
        String[] gavKK = deploymentId.split(":");
        KModuleDeploymentUnit deployUnit = new KModuleDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
        if (gavKK.length > 3) {
            deployUnit.setKbaseName(gavKK[3]);
        }
        if (gavKK.length > 4) {
            deployUnit.setKsessionName(gavKK[4]);
        }
        if (descriptor != null) {
            deployUnit.setDeploymentDescriptor((DeploymentDescriptor)descriptor);
        }
        return deployUnit;
    }

    public static JaxbDeploymentUnit convertKModuleDepUnitToJaxbDepUnit(KModuleDeploymentUnit kDepUnit) {
        JaxbDeploymentUnit jDepUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getVersion(), kDepUnit.getKbaseName(), kDepUnit.getKsessionName());
        jDepUnit.setStrategy(kDepUnit.getStrategy());
        return jDepUnit;
    }

    @GET
    @Path(value="/")
    public Response getConfig() {
        JaxbDeploymentUnit jaxbDepUnit;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit == null) {
            JaxbDeploymentUnit.JaxbDeploymentStatus status = JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT;
            String[] gavKK = this.deploymentId.split(":");
            jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
            jaxbDepUnit.setStatus(status);
        } else {
            jaxbDepUnit = this.extractDeploymentUnit(deployedUnit);
            jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
        }
        logger.debug("Returning deployment unit information for " + this.deploymentId);
        return DeploymentResource.createCorrectVariant(jaxbDepUnit, this.headers);
    }

    private JaxbDeploymentUnit extractDeploymentUnit(DeployedUnit deployedUnit) {
        KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
        return DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit);
    }

    @POST
    @Path(value="/deploy")
    @Consumes(value={"application/xml", "*"})
    public Response deploy(DeploymentDescriptorImpl descriptor) {
        Map<String, List<String>> params = DeploymentResource.getRequestParams(this.uriInfo);
        String oper = DeploymentResource.getRelativePath(this.uriInfo);
        String strategy = DeploymentResource.getStringParam("strategy", false, params, oper);
        String mergeMode = DeploymentResource.getStringParam("mergemode", false, params, oper);
        KModuleDeploymentUnit deploymentUnit = this.createDeploymentUnit(this.deploymentId, descriptor);
        if (strategy != null) {
            DeploymentUnit.RuntimeStrategy runtimeStrategy;
            strategy = strategy.toUpperCase();
            try {
                runtimeStrategy = DeploymentUnit.RuntimeStrategy.valueOf((String)strategy);
            }
            catch (IllegalArgumentException iae) {
                throw RestOperationException.badRequest((String)("Runtime strategy '" + strategy + "' does not exist."));
            }
            deploymentUnit.setStrategy(runtimeStrategy);
        }
        if (mergeMode != null) {
            MergeMode mode;
            mergeMode = mergeMode.toUpperCase();
            try {
                mode = MergeMode.valueOf((String)mergeMode);
            }
            catch (IllegalArgumentException iae) {
                throw RestOperationException.badRequest((String)("Merge mode '" + mergeMode + "' does not exist."));
            }
            deploymentUnit.setMergeMode(mode);
        }
        String typeName = JobType.DEPLOY.toString();
        String typeNameLower = typeName.toLowerCase();
        CommandContext ctx = new CommandContext();
        ctx.setData("DeploymentUnit", (Object)deploymentUnit);
        ctx.setData("JobType", (Object)JobType.DEPLOY);
        ctx.setData("businessKey", (Object)this.deploymentId);
        ctx.setData("retries", (Object)0);
        long id = this.jobExecutor.scheduleRequest(DeploymentCmd.class.getName(), ctx);
        JaxbDeploymentJobResult jobResult = new JaxbDeploymentJobResult(Long.valueOf(id), "Deployment (" + typeNameLower + ") job submitted successfully.", true, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(deploymentUnit), typeName);
        jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING);
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/undeploy")
    public Response undeploy() {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            String typeName = JobType.UNDEPLOY.toString();
            String typeNameLower = typeName.toLowerCase();
            CommandContext ctx = new CommandContext();
            ctx.setData("DeploymentUnit", (Object)deploymentUnit);
            ctx.setData("JobType", (Object)JobType.UNDEPLOY);
            ctx.setData("businessKey", (Object)this.deploymentId);
            ctx.setData("retries", (Object)0);
            long id = this.jobExecutor.scheduleRequest(DeploymentCmd.class.getName(), ctx);
            jobResult = new JaxbDeploymentJobResult(Long.valueOf(id), "Deployment (" + typeNameLower + ") job submitted successfully.", true, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(deploymentUnit), typeName);
            jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING);
        } else {
            JaxbDeploymentUnit depUnit;
            String[] gavKK = this.deploymentId.split(":");
            switch (gavKK.length) {
                case 3: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
                    break;
                }
                case 4: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], null);
                    break;
                }
                case 5: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], gavKK[4]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid deployment id: " + this.deploymentId);
                }
            }
            jobResult = new JaxbDeploymentJobResult(null, "Deployment unit has already been undeployed.", true, depUnit, "UNDEPLOY");
        }
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }
}

