/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.async.cmd;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.jbpm.executor.cdi.CDIUtils;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentCmd
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentCmd.class);

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        BeanManager beanManager = CDIUtils.lookUpBeanManager((CommandContext)ctx);
        DeploymentService deploymentService = (DeploymentService)CDIUtils.createBean(DeploymentService.class, (BeanManager)beanManager, (Annotation[])new Annotation[]{new AnnotationLiteral<Kjar>(){}});
        KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)ctx.getData("DeploymentUnit");
        JobType type = (JobType)((Object)ctx.getData("JobType"));
        boolean success = false;
        switch (type) {
            case DEPLOY: {
                try {
                    deploymentService.deploy((DeploymentUnit)deploymentUnit);
                    logger.debug("Deployment unit [" + deploymentUnit.getIdentifier() + "] deployed");
                    success = true;
                }
                catch (Exception e) {
                    logger.error("Unable to deploy [" + deploymentUnit.getIdentifier() + "]", (Throwable)e);
                }
                break;
            }
            case UNDEPLOY: {
                try {
                    deploymentService.undeploy((DeploymentUnit)deploymentUnit);
                    logger.debug("Deployment unit [" + deploymentUnit.getIdentifier() + "] undeployed");
                    success = true;
                }
                catch (Exception e) {
                    logger.error("Unable to undeploy [" + deploymentUnit.getIdentifier() + "]", (Throwable)e);
                }
                break;
            }
            default: {
                logger.error("Unknown " + JobType.class.getSimpleName() + " type (" + type.toString() + "), not taking any action");
            }
        }
        ExecutionResults results = new ExecutionResults();
        results.setData("Result", (Object)success);
        return results;
    }
}

