/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.async;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobResultManager {
    private static final Logger logger = LoggerFactory.getLogger(JobResultManager.class);
    private static AtomicInteger created = new AtomicInteger(0);
    private Map<String, JaxbDeploymentJobResult> jobs = null;
    private Map<String, String> deploymentIdMostRecentJobIdMap = null;
    private int maxCacheSize = 10000;

    @PostConstruct
    public void start() {
        if (!created.compareAndSet(0, 1)) {
            throw new IllegalStateException("Only 1 JobResultManager instance is allowed per container!");
        }
        Cache cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(cache);
        Cache idCache = new Cache(this.maxCacheSize);
        this.deploymentIdMostRecentJobIdMap = Collections.synchronizedMap(idCache);
    }

    public void putJob(String jobId, JaxbDeploymentJobResult job, JobType jobType) {
        JaxbDeploymentJobResult oldJobResult;
        logger.debug("Adding job [{}] to cache");
        this.jobs.put(jobId, job);
        String deploymentId = job.getDeploymentUnit().getIdentifier();
        logger.debug("Adding job id [{}] to \"most recent job\" cache");
        String oldJobId = this.deploymentIdMostRecentJobIdMap.put(deploymentId, jobId);
        if (oldJobId != null && !JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED.equals((Object)(oldJobResult = this.jobs.get(oldJobId)).getDeploymentUnit().getStatus()) && !JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED.equals((Object)oldJobResult.getDeploymentUnit().getStatus())) {
            logger.info("New {} job [{}] for '{}' requested while old job [{}] has status {}", new Object[]{jobType.toString().toLowerCase(), jobId, oldJobResult.getDeploymentUnit().getIdentifier(), oldJobId, oldJobResult.getDeploymentUnit().getStatus()});
        }
    }

    public JaxbDeploymentJobResult getJob(String jobId) {
        logger.debug("Getting job [{}]");
        return this.jobs.get(jobId);
    }

    public JaxbDeploymentJobResult getMostRecentJob(String deploymentId) {
        logger.debug("Getting most recent job for '{}'", (Object)deploymentId);
        String jobId = this.deploymentIdMostRecentJobIdMap.get(deploymentId);
        if (jobId != null) {
            return this.jobs.get(jobId);
        }
        return null;
    }

    private static class Cache<T>
    extends LinkedHashMap<String, T> {
        private int maxSize = 1000;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

