/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.ReleaseId;

@XmlRootElement(name="release-id-filter")
@XStreamAlias(value="release-id-filter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ReleaseIdFilter {
    @XmlElement(name="group-id")
    @XStreamAlias(value="group-id")
    private final String groupId;
    @XmlElement(name="artifact-id")
    @XStreamAlias(value="artifact-id")
    private final String artifactId;
    @XmlElement(name="version")
    @XStreamAlias(value="version")
    private final String version;
    public static final ReleaseIdFilter ACCEPT_ALL = new ReleaseIdFilter(null, null, null);

    private ReleaseIdFilter() {
        this(null, null, null);
    }

    public ReleaseIdFilter(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ReleaseIdFilter(ReleaseId releaseId) {
        this(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean accept(ReleaseId releaseId) {
        if (releaseId == null) {
            throw new IllegalArgumentException("ReleaseId can not be null!");
        }
        return this.matches(this.groupId, releaseId.getGroupId()) && this.matches(this.artifactId, releaseId.getArtifactId()) && this.matches(this.version, releaseId.getVersion());
    }

    private boolean matches(String filter, String value) {
        if (filter == null) {
            return true;
        }
        return filter.equals(value);
    }

    public String toString() {
        return "ReleaseIdFilter{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseIdFilter that = (ReleaseIdFilter)o;
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder releaseId(ReleaseId releaseId) {
            this.groupId = releaseId.getGroupId();
            this.artifactId = releaseId.getArtifactId();
            this.version = releaseId.getVersion();
            return this;
        }

        public ReleaseIdFilter build() {
            return new ReleaseIdFilter(this.groupId, this.artifactId, this.version);
        }
    }
}

