/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;

public class QueryFilterSpecBuilder {
    private List<QueryParam> parameters = new ArrayList<QueryParam>();
    private QueryFilterSpec filterSpec = new QueryFilterSpec();
    private Map<String, String> columnMapping = new HashMap<String, String>();

    public QueryFilterSpec get() {
        if (!this.parameters.isEmpty()) {
            this.filterSpec.setParameters(this.parameters.toArray(new QueryParam[this.parameters.size()]));
        }
        if (!this.columnMapping.isEmpty()) {
            this.filterSpec.setColumnMapping(this.columnMapping);
        }
        return this.filterSpec;
    }

    public QueryFilterSpecBuilder oderBy(String column, boolean isAscending) {
        this.filterSpec.setOrderBy(column);
        this.filterSpec.setAscending(isAscending);
        return this;
    }

    public QueryFilterSpecBuilder isNull(String column) {
        this.parameters.add(new QueryParam(column, "IS_NULL", null));
        return this;
    }

    public QueryFilterSpecBuilder isNotNull(String column) {
        this.parameters.add(new QueryParam(column, "NOT_NULL", null));
        return this;
    }

    public QueryFilterSpecBuilder equalsTo(String column, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(column, "EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public QueryFilterSpecBuilder notEqualsTo(String column, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(column, "NOT_EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public QueryFilterSpecBuilder likeTo(String column, boolean caseSensitive, Comparable<?> value) {
        this.parameters.add(new QueryParam(column, "LIKE_TO", Arrays.asList(value, caseSensitive)));
        return this;
    }

    public QueryFilterSpecBuilder greaterThan(String column, Comparable<?> value) {
        this.parameters.add(new QueryParam(column, "GREATER_THAN", Arrays.asList(value)));
        return this;
    }

    public QueryFilterSpecBuilder greaterOrEqualTo(String column, Comparable<?> value) {
        this.parameters.add(new QueryParam(column, "GREATER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public QueryFilterSpecBuilder lowerThan(String column, Comparable<?> value) {
        this.parameters.add(new QueryParam(column, "LOWER_THAN", Arrays.asList(value)));
        return this;
    }

    public QueryFilterSpecBuilder lowerOrEqualTo(String column, Comparable<?> value) {
        this.parameters.add(new QueryParam(column, "LOWER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public QueryFilterSpecBuilder between(String column, Comparable<?> start, Comparable<?> end) {
        this.parameters.add(new QueryParam(column, "BETWEEN", Arrays.asList(start, end)));
        return this;
    }

    public QueryFilterSpecBuilder in(String column, List<?> values) {
        this.parameters.add(new QueryParam(column, "IN", values));
        return this;
    }

    public QueryFilterSpecBuilder notIn(String column, List<?> values) {
        this.parameters.add(new QueryParam(column, "NOT_IN", values));
        return this;
    }

    public QueryFilterSpecBuilder addColumnMapping(String column, String type) {
        this.columnMapping.put(column, type);
        return this;
    }
}

