/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.json.JSONMarshallerExtension;

public class JSONMarshallerPMMLRequest
implements JSONMarshallerExtension {
    private static final PMMLRequestDeserializer DESERIALIZER = new PMMLRequestDeserializer();
    private static final PMMLRequestSerializer SERIALIZER = new PMMLRequestSerializer();
    private static final String CORRELATION_ID = "correlationId";
    private static final String MODEL_NAME = "modelName";
    private static final String SOURCE = "source";

    @Override
    public void extend(JSONMarshaller marshaller, ObjectMapper serializer, ObjectMapper deserializer) {
        this.registerModule(serializer);
        this.registerModule(deserializer);
    }

    private void registerModule(ObjectMapper objectMapper) {
        SimpleModule pmmlRequestModule = new SimpleModule("pmml-module", Version.unknownVersion());
        pmmlRequestModule.addDeserializer(PMMLRequestData.class, (JsonDeserializer)DESERIALIZER);
        pmmlRequestModule.addSerializer(PMMLRequestData.class, (JsonSerializer)SERIALIZER);
        objectMapper.registerModule((Module)pmmlRequestModule);
    }

    private static class PMMLRequestSerializer
    extends JsonSerializer<PMMLRequestData> {
        private PMMLRequestSerializer() {
        }

        public void serialize(PMMLRequestData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject((Object)value);
            gen.writeFieldName(JSONMarshallerPMMLRequest.CORRELATION_ID);
            gen.writeString(value.getCorrelationId());
            gen.writeFieldName(JSONMarshallerPMMLRequest.MODEL_NAME);
            gen.writeString(value.getModelName());
            gen.writeFieldName(JSONMarshallerPMMLRequest.SOURCE);
            gen.writeString(value.getSource());
            Collection params = value.getRequestParams();
            if (params != null && !params.isEmpty()) {
                gen.writeFieldName("requestParams");
                gen.writeStartArray(params.size());
                for (ParameterInfo p : params) {
                    gen.writeStartObject((Object)p);
                    serializers.defaultSerializeValue((Object)p, gen);
                    gen.writeEndObject();
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    }

    private static class PMMLRequestDeserializer
    extends JsonDeserializer<PMMLRequestData> {
        private PMMLRequestDeserializer() {
        }

        public PMMLRequestData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            PMMLRequestData request = new PMMLRequestData();
            if (p.isExpectedStartObjectToken()) {
                String fldName = null;
                String fldVal = null;
                do {
                    JsonToken token = p.nextToken();
                    switch (token) {
                        case FIELD_NAME: {
                            fldName = p.getText();
                            break;
                        }
                        case VALUE_STRING: {
                            fldVal = p.getText();
                        }
                    }
                    if (fldName == null || fldVal == null) continue;
                    if (fldName.equals(JSONMarshallerPMMLRequest.CORRELATION_ID)) {
                        request.setCorrelationId(fldVal);
                    } else if (fldName.equals(JSONMarshallerPMMLRequest.MODEL_NAME)) {
                        request.setModelName(fldVal);
                    } else if (fldName.equals(JSONMarshallerPMMLRequest.SOURCE)) {
                        request.setSource(fldVal);
                    }
                    fldName = null;
                    fldVal = null;
                } while (!p.isExpectedStartArrayToken());
            }
            if (p.isExpectedStartArrayToken()) {
                p.nextToken();
                while (p.isExpectedStartObjectToken()) {
                    ParameterInfo pi;
                    JsonToken tok;
                    HashMap<String, String> values = new HashMap<String, String>();
                    String fieldName = null;
                    String fieldVal = null;
                    do {
                        tok = p.nextToken();
                        switch (tok) {
                            case FIELD_NAME: {
                                fieldName = p.getText();
                                break;
                            }
                            case VALUE_STRING: {
                                fieldVal = p.getText();
                            }
                        }
                        if (fieldName == null || fieldVal == null) continue;
                        values.put(fieldName, fieldVal);
                        fieldName = null;
                        fieldVal = null;
                    } while (tok != JsonToken.END_OBJECT);
                    p.nextToken();
                    values.entrySet().forEach(e -> System.out.println((String)e.getKey() + ": " + (String)e.getValue()));
                    String pitype = (String)values.get("type");
                    if (pitype == null || pitype.trim().isEmpty()) continue;
                    if (pitype.equals(String.class.getName())) {
                        pi = new ParameterInfo((String)values.get(JSONMarshallerPMMLRequest.CORRELATION_ID), (String)values.get("name"), String.class, (Object)((String)values.get("value")));
                        request.addRequestParam(pi);
                        continue;
                    }
                    if (pitype.equals(Integer.class.getName())) {
                        pi = new ParameterInfo();
                        pi.setCorrelationId((String)values.get(JSONMarshallerPMMLRequest.CORRELATION_ID));
                        pi.setName((String)values.get("name"));
                        pi.setType(Integer.class);
                        pi.setValue((Object)Integer.valueOf((String)values.get("value")));
                        request.addRequestParam(pi);
                        continue;
                    }
                    if (pitype.equals(Long.class.getName())) {
                        pi = new ParameterInfo();
                        pi.setCorrelationId((String)values.get(JSONMarshallerPMMLRequest.CORRELATION_ID));
                        pi.setName((String)values.get("name"));
                        pi.setType(Long.class);
                        pi.setValue((Object)Long.valueOf((String)values.get("value")));
                        request.addRequestParam(pi);
                        continue;
                    }
                    if (!pitype.equals(Float.class.getName()) && !pitype.equals(Double.class.getName())) continue;
                    pi = new ParameterInfo();
                    pi.setCorrelationId((String)values.get(JSONMarshallerPMMLRequest.CORRELATION_ID));
                    pi.setName((String)values.get("name"));
                    pi.setType(Double.class);
                    pi.setValue((Object)Double.valueOf((String)values.get("value")));
                    request.addRequestParam(pi);
                }
            }
            return request;
        }
    }
}

