/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMetadata;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.model.dmn.DMNDecisionResultKS;
import org.kie.server.api.model.dmn.DMNMessageKS;
import org.kie.server.api.model.dmn.DMNNodeStub;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dmn-evaluation-result")
@XStreamAlias(value="dmn-evaluation-result")
public class DMNResultKS
implements DMNResult {
    @XmlElement(name="model-namespace")
    @XStreamAlias(value="model-namespace")
    private String namespace;
    @XmlElement(name="model-name")
    @XStreamAlias(value="model-name")
    private String modelName;
    @XmlElement(name="decision-name")
    @XStreamImplicit(itemFieldName="decision-name")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<String> decisionNames = new ArrayList<String>();
    @XmlElement(name="dmn-context")
    @XStreamAlias(value="dmn-context")
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    @JsonSerialize(using=JSONMarshaller.PassThruSerializer.class)
    private Map<String, Object> dmnContext = new HashMap<String, Object>();
    @XmlElementWrapper(name="messages")
    @XStreamAlias(value="messages")
    private List<DMNMessageKS> messages = new ArrayList<DMNMessageKS>();
    @XmlElement(name="decision-results")
    @XStreamAlias(value="decision-results")
    private Map<String, DMNDecisionResultKS> decisionResults = new HashMap<String, DMNDecisionResultKS>();

    public DMNResultKS() {
    }

    public DMNResultKS(DMNResult dmnResult) {
        this.setDmnContext(dmnResult.getContext().getAll());
        this.setMessages(dmnResult.getMessages());
        this.setDecisionResults(dmnResult.getDecisionResults());
    }

    public DMNResultKS(String namespace, String modelName, DMNResult dmnResult) {
        this(dmnResult);
        this.namespace = namespace;
        this.modelName = modelName;
    }

    public DMNResultKS(String namespace, String modelName, List<String> decisionNames, DMNResult dmnResult) {
        this(namespace, modelName, dmnResult);
        this.decisionNames = decisionNames;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public List<String> getDecisionNames() {
        return this.decisionNames;
    }

    public void setDecisionNames(List<String> decisionNames) {
        this.decisionNames = decisionNames;
    }

    public Map<String, Object> getDmnContext() {
        return this.dmnContext;
    }

    public void setDmnContext(Map<String, Object> dmnContext) {
        this.dmnContext = new HashMap<String, Object>();
        for (Map.Entry<String, Object> kv : dmnContext.entrySet()) {
            this.dmnContext.put(kv.getKey(), DMNResultKS.stubDMNResult(kv.getValue()));
        }
    }

    public void setMessages(List<DMNMessage> messages) {
        for (DMNMessage m : messages) {
            this.messages.add(DMNMessageKS.of(m));
        }
    }

    public void setDecisionResults(List<DMNDecisionResult> decisionResults) {
        for (DMNDecisionResult dr : decisionResults) {
            this.decisionResults.put(dr.getDecisionId(), DMNDecisionResultKS.of(dr));
        }
    }

    public DMNContext getContext() {
        return MapBackedDMNContext.of(this.dmnContext);
    }

    public List<DMNMessage> getMessages() {
        ArrayList<DMNMessage> res = new ArrayList<DMNMessage>();
        this.messages.forEach(x -> res.add((DMNMessage)x));
        return res;
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.stream().filter(m -> Arrays.asList(sevs).stream().anyMatch(f -> f.equals((Object)m.getSeverity()))).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return this.messages.stream().anyMatch(m -> DMNMessage.Severity.ERROR.equals((Object)m.getSeverity()));
    }

    public List<DMNDecisionResult> getDecisionResults() {
        return new ArrayList<DMNDecisionResult>(this.decisionResults.values());
    }

    public DMNDecisionResult getDecisionResultByName(String name) {
        return this.decisionResults.values().stream().filter(dr -> dr.getDecisionName().equals(name)).findFirst().get();
    }

    public DMNDecisionResult getDecisionResultById(String id) {
        return this.decisionResults.get(id);
    }

    public String toString() {
        return "DMNResultKS [" + "namespace=" + this.namespace + ", modelName=" + this.modelName + ", decisionNames=" + this.decisionNames + ", dmnContext=" + this.dmnContext + ", messages=" + this.messages + ", decisionResults=" + this.decisionResults + "]";
    }

    public static Object stubDMNResult(Object result) {
        if (result instanceof DMNContext) {
            HashMap<String, Object> stubbedContextValues = new HashMap<String, Object>();
            for (Map.Entry kv : ((DMNContext)result).getAll().entrySet()) {
                stubbedContextValues.put((String)kv.getKey(), DMNResultKS.stubDMNResult(kv.getValue()));
            }
            return MapBackedDMNContext.of(stubbedContextValues);
        }
        if (result instanceof Map) {
            HashMap stubbedValues = new HashMap();
            for (Map.Entry kv : ((Map)result).entrySet()) {
                stubbedValues.put(kv.getKey(), DMNResultKS.stubDMNResult(kv.getValue()));
            }
            return stubbedValues;
        }
        if (result instanceof List) {
            List stubbedValues = ((List)result).stream().map(DMNResultKS::stubDMNResult).collect(Collectors.toList());
            return stubbedValues;
        }
        if (result instanceof Set) {
            Set stubbedValues = ((Set)result).stream().map(DMNResultKS::stubDMNResult).collect(Collectors.toSet());
            return stubbedValues;
        }
        if (result != null && result.getClass().getPackage().getName().startsWith("org.kie.dmn")) {
            return DMNNodeStub.of(result);
        }
        return result;
    }

    static class MapBackedDMNContext
    implements DMNContext {
        private Deque<ScopeReference> stack = new LinkedList<ScopeReference>();
        private Map<String, Object> ctx;
        private DMNMetadata metadata;

        private MapBackedDMNContext() {
            this.ctx = new HashMap<String, Object>();
            this.metadata = new Metadata();
        }

        private MapBackedDMNContext(Map<String, Object> ctx) {
            this.ctx = ctx;
            this.metadata = new Metadata();
        }

        private MapBackedDMNContext(Map<String, Object> ctx, Map<String, Object> metadata) {
            this.ctx = ctx;
            this.metadata = new Metadata(metadata);
        }

        public static MapBackedDMNContext of(Map<String, Object> ctx) {
            return new MapBackedDMNContext(ctx);
        }

        public static MapBackedDMNContext of(Map<String, Object> ctx, Map<String, Object> metadata) {
            return new MapBackedDMNContext(ctx, metadata);
        }

        public DMNContext clone() {
            return MapBackedDMNContext.of(new HashMap<String, Object>(this.ctx), new HashMap<String, Object>(this.metadata.asMap()));
        }

        public Object set(String name, Object value) {
            return this.getCurrentEntries().put(name, value);
        }

        public Object get(String name) {
            return this.getCurrentEntries().get(name);
        }

        private Map<String, Object> getCurrentEntries() {
            if (this.stack.isEmpty()) {
                return this.ctx;
            }
            return this.stack.peek().getRef();
        }

        public void pushScope(String name, String namespace) {
            Map scopeRef = (Map)this.getCurrentEntries().computeIfAbsent(name, s -> new LinkedHashMap());
            this.stack.push(new ScopeReference(name, namespace, scopeRef));
        }

        public void popScope() {
            this.stack.pop();
        }

        public Optional<String> scopeNamespace() {
            if (this.stack.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.stack.peek().getNamespace());
        }

        public Map<String, Object> getAll() {
            return this.getCurrentEntries();
        }

        public boolean isDefined(String name) {
            return this.getCurrentEntries().containsKey(name);
        }

        public DMNMetadata getMetadata() {
            return this.metadata;
        }

        private static class ScopeReference {
            private final String name;
            private final String namespace;
            private final Map<String, Object> ref;

            public ScopeReference(String name, String namespace, Map<String, Object> ref) {
                this.name = name;
                this.namespace = namespace;
                this.ref = ref;
            }

            public String getName() {
                return this.name;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public Map<String, Object> getRef() {
                return this.ref;
            }
        }

        private static class Metadata
        implements DMNMetadata {
            private Map<String, Object> entries;

            public Metadata() {
                this.entries = new HashMap<String, Object>();
            }

            public Metadata(Map<String, Object> entries) {
                this.entries = entries;
            }

            public Object set(String name, Object value) {
                return this.entries.put(name, value);
            }

            public Object get(String name) {
                return this.entries.get(name);
            }

            public Map<String, Object> asMap() {
                return Collections.unmodifiableMap(this.entries);
            }
        }
    }
}

