/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;

@XmlRootElement(name="kie-container-filter")
@XStreamAlias(value="kie-container-filter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class KieContainerResourceFilter {
    public static final KieContainerResourceFilter ACCEPT_ALL = new KieContainerResourceFilter();
    @XmlElement(name="release-id-filter")
    @XStreamAlias(value="release-id-filter")
    private final ReleaseIdFilter releaseIdFilter;
    @XmlElement(name="container-status-filter")
    @XStreamAlias(value="container-status-filter")
    private final KieContainerStatusFilter statusFilter;

    private KieContainerResourceFilter() {
        this.releaseIdFilter = ReleaseIdFilter.ACCEPT_ALL;
        this.statusFilter = KieContainerStatusFilter.ACCEPT_ALL;
    }

    public KieContainerResourceFilter(ReleaseIdFilter releaseIdFilter, KieContainerStatusFilter statusFilter) {
        this.releaseIdFilter = releaseIdFilter;
        this.statusFilter = statusFilter;
    }

    public KieContainerResourceFilter(ReleaseIdFilter releaseIdFilter) {
        this(releaseIdFilter, KieContainerStatusFilter.ACCEPT_ALL);
    }

    public ReleaseIdFilter getReleaseIdFilter() {
        return this.releaseIdFilter;
    }

    public KieContainerStatusFilter getStatusFilter() {
        return this.statusFilter;
    }

    public boolean accept(KieContainerResource kieContainerResource) {
        if (kieContainerResource == null) {
            throw new IllegalArgumentException("KieContainerResource can not be null!");
        }
        ReleaseId resolvedReleaseId = kieContainerResource.getResolvedReleaseId();
        if (resolvedReleaseId != null ? !this.releaseIdFilter.accept(resolvedReleaseId) : !this.releaseIdFilter.accept(kieContainerResource.getReleaseId())) {
            return false;
        }
        KieContainerStatus status = kieContainerResource.getStatus();
        return status == null || this.statusFilter.accept(status);
    }

    public String toURLQueryString() {
        StringJoiner joiner = new StringJoiner("&");
        if (this.releaseIdFilter.getGroupId() != null) {
            joiner.add("groupId=" + this.releaseIdFilter.getGroupId());
        }
        if (this.releaseIdFilter.getArtifactId() != null) {
            joiner.add("artifactId=" + this.releaseIdFilter.getArtifactId());
        }
        if (this.releaseIdFilter.getVersion() != null) {
            joiner.add("version=" + this.releaseIdFilter.getVersion());
        }
        if (!this.statusFilter.equals(KieContainerStatusFilter.ACCEPT_ALL)) {
            String status = this.statusFilter.getAcceptedStatuses().stream().map(s -> s.toString()).collect(Collectors.joining(","));
            joiner.add("status=" + status);
        }
        return joiner.toString();
    }

    public String toString() {
        return "KieContainerResourceFilter{releaseIdFilter=" + this.releaseIdFilter + ", statusFilter=" + this.statusFilter + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieContainerResourceFilter that = (KieContainerResourceFilter)o;
        if (this.releaseIdFilter != null ? !this.releaseIdFilter.equals(that.releaseIdFilter) : that.releaseIdFilter != null) {
            return false;
        }
        return this.statusFilter != null ? this.statusFilter.equals(that.statusFilter) : that.statusFilter == null;
    }

    public int hashCode() {
        int result = this.releaseIdFilter != null ? this.releaseIdFilter.hashCode() : 0;
        result = 31 * result + (this.statusFilter != null ? this.statusFilter.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private ReleaseIdFilter releaseIdFilter = ReleaseIdFilter.ACCEPT_ALL;
        private KieContainerStatusFilter statusFilter = KieContainerStatusFilter.ACCEPT_ALL;

        public Builder releaseId(ReleaseId releaseId) {
            this.releaseIdFilter = new ReleaseIdFilter(releaseId);
            return this;
        }

        public Builder releaseId(String groupId, String artifactId, String version) {
            this.releaseIdFilter = new ReleaseIdFilter(groupId, artifactId, version);
            return this;
        }

        public Builder status(KieContainerStatus containerStatus) {
            this.statusFilter = new KieContainerStatusFilter(containerStatus);
            return this;
        }

        public Builder statuses(KieContainerStatus ... containerStatuses) {
            this.statusFilter = new KieContainerStatusFilter(containerStatuses);
            return this;
        }

        public KieContainerResourceFilter build() {
            return new KieContainerResourceFilter(this.releaseIdFilter, this.statusFilter);
        }
    }
}

