/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.websocket;

import java.io.IOException;
import java.util.function.Consumer;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.commands.KieServerControllerDescriptorCommand;
import org.kie.server.controller.api.model.KieServerControllerServiceResponse;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.controller.client.websocket.WebSocketEventHandler;
import org.kie.server.controller.websocket.common.KieServerControllerNotificationWebSocketClient;
import org.kie.server.controller.websocket.common.KieServerMessageHandlerWebSocketClient;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.common.config.WebSocketClientConfiguration;
import org.kie.server.controller.websocket.common.decoder.KieServerControllerNotificationDecoder;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.WebSocketServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketKieServerControllerClient
implements KieServerControllerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketKieServerControllerClient.class);
    private KieServerMessageHandlerWebSocketClient client;
    private KieServerControllerNotificationWebSocketClient notificationClient;

    public WebSocketKieServerControllerClient(String controllerUrl, String userName, String password, String token, EventHandler handler) {
        this(controllerUrl, userName, password, token, new KieServerMessageHandlerWebSocketClient(), handler == null ? null : new KieServerControllerNotificationWebSocketClient((Consumer)new WebSocketEventHandler(handler)));
    }

    public WebSocketKieServerControllerClient(String controllerUrl, String userName, String password, String token, KieServerMessageHandlerWebSocketClient client, KieServerControllerNotificationWebSocketClient notificationClient) {
        this.client = client;
        this.client.init(WebSocketClientConfiguration.builder().controllerUrl(controllerUrl + "/management").userName(userName).password(password).token(token).build());
        if (notificationClient != null) {
            this.notificationClient = notificationClient;
            this.notificationClient.init(WebSocketClientConfiguration.builder().controllerUrl(controllerUrl + "/notification").userName(userName).password(password).token(token).decoders(new Class[]{KieServerControllerNotificationDecoder.class}).build());
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        if (this.notificationClient != null) {
            this.notificationClient.close();
        }
    }

    private <T> T sendCommand(String service, String method, Object ... arguments) {
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(service, method, arguments);
        LOGGER.debug("About to send descriptor command to kie server controller: {}", (Object)command);
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("Content to be sent over Web Socket '{}'", (Object)content);
        try {
            WebSocketServiceResponse response = this.getMessageHandler();
            this.client.sendTextWithInternalHandler(content, (InternalMessageHandler)response);
            LOGGER.debug("Message successfully sent to kie server controller");
            if (response.getType() == KieServiceResponse.ResponseType.FAILURE) {
                throw new KieServerControllerClientException(response.getMsg());
            }
            return (T)response.getResult();
        }
        catch (KieServerControllerClientException e) {
            LOGGER.warn("Received Web Socket service error with message: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error trying to send message to kie server controller", (Throwable)e);
            throw new KieServerControllerClientException(e);
        }
    }

    protected WebSocketServiceResponse getMessageHandler() {
        return new WebSocketServiceResponse(true, message -> (KieServerControllerServiceResponse)WebSocketUtils.unmarshal((String)message, KieServerControllerServiceResponse.class));
    }

    public ServerTemplateList listServerTemplates() {
        return (ServerTemplateList)this.sendCommand(SpecManagementService.class.getName(), "listServerTemplates", new Object[0]);
    }

    public void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.sendCommand(SpecManagementService.class.getName(), "saveContainerSpec", serverTemplateId, containerSpec);
    }

    public void updateContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.sendCommand(SpecManagementService.class.getName(), "updateContainerSpec", serverTemplateId, containerSpec);
    }

    public void updateContainerSpec(String serverTemplateId, String containerId, ContainerSpec containerSpec) {
        this.sendCommand(SpecManagementService.class.getName(), "updateContainerSpec", serverTemplateId, containerId, containerSpec);
    }

    public void saveServerTemplate(ServerTemplate serverTemplate) {
        this.sendCommand(SpecManagementService.class.getName(), "saveServerTemplate", serverTemplate);
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        return (ServerTemplate)this.sendCommand(SpecManagementService.class.getName(), "getServerTemplate", serverTemplateId);
    }

    public ServerTemplateKeyList listServerTemplateKeys() {
        return (ServerTemplateKeyList)this.sendCommand(SpecManagementService.class.getName(), "listServerTemplateKeys", new Object[0]);
    }

    public ContainerSpecList listContainerSpec(String serverTemplateId) {
        return (ContainerSpecList)this.sendCommand(SpecManagementService.class.getName(), "listContainerSpec", serverTemplateId);
    }

    public ContainerSpec getContainerInfo(String serverTemplateId, String containerId) {
        return (ContainerSpec)this.sendCommand(SpecManagementService.class.getName(), "getContainerInfo", serverTemplateId, containerId);
    }

    public void deleteContainerSpec(String serverTemplateId, String containerSpecId) {
        this.sendCommand(SpecManagementService.class.getName(), "deleteContainerSpec", serverTemplateId, containerSpecId);
    }

    public void deleteServerTemplate(String serverTemplateId) {
        this.sendCommand(SpecManagementService.class.getName(), "deleteServerTemplate", serverTemplateId);
    }

    public void copyServerTemplate(String serverTemplateId, String newServerTemplateId, String newServerTemplateName) {
        this.sendCommand(SpecManagementService.class.getName(), "copyServerTemplate", serverTemplateId, newServerTemplateId, newServerTemplateName);
    }

    public void updateContainerConfig(String serverTemplateId, String containerSpecId, Capability capability, ContainerConfig containerConfig) {
        this.sendCommand(SpecManagementService.class.getName(), "updateContainerConfig", serverTemplateId, containerSpecId, capability, containerConfig);
    }

    public void updateServerTemplateConfig(String serverTemplateId, Capability capability, ServerConfig serverConfig) {
        this.sendCommand(SpecManagementService.class.getName(), "updateServerTemplateConfig", serverTemplateId, capability, serverConfig);
    }

    public void startContainer(ContainerSpecKey containerSpecKey) {
        this.sendCommand(SpecManagementService.class.getName(), "startContainer", containerSpecKey);
    }

    public void stopContainer(ContainerSpecKey containerSpecKey) {
        this.sendCommand(SpecManagementService.class.getName(), "stopContainer", containerSpecKey);
    }

    public void activateContainer(ContainerSpecKey containerSpecKey) {
        this.sendCommand(SpecManagementService.class.getName(), "activateContainer", containerSpecKey);
    }

    public void deactivateContainer(ContainerSpecKey containerSpecKey) {
        this.sendCommand(SpecManagementService.class.getName(), "deactivateContainer", containerSpecKey);
    }

    public void scanNow(ContainerSpecKey containerSpecKey) {
        this.sendCommand(RuleCapabilitiesService.class.getName(), "scanNow", containerSpecKey);
    }

    public void startScanner(ContainerSpecKey containerSpecKey, Long interval) {
        this.sendCommand(RuleCapabilitiesService.class.getName(), "startScanner", containerSpecKey, interval);
    }

    public void stopScanner(ContainerSpecKey containerSpecKey) {
        this.sendCommand(RuleCapabilitiesService.class.getName(), "stopScanner", containerSpecKey);
    }

    public void upgradeContainer(ContainerSpecKey containerSpecKey, ReleaseId releaseId) {
        this.sendCommand(RuleCapabilitiesService.class.getName(), "upgradeContainer", containerSpecKey, releaseId);
    }

    public ContainerList getContainers(ServerInstanceKey serverInstanceKey) {
        return (ContainerList)this.sendCommand(RuntimeManagementService.class.getName(), "getContainers", serverInstanceKey);
    }

    public ContainerList getContainers(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        return (ContainerList)this.sendCommand(RuntimeManagementService.class.getName(), "getContainers", serverTemplate, containerSpec);
    }

    public ServerInstanceKeyList getServerInstances(String serverTemplateId) {
        return (ServerInstanceKeyList)this.sendCommand(RuntimeManagementService.class.getName(), "getServerInstances", serverTemplateId);
    }

    public void deleteServerInstance(ServerInstanceKey serverInstanceKey) {
        this.sendCommand(SpecManagementService.class.getName(), "deleteServerInstance", serverInstanceKey);
    }
}

