/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client;

import javax.ws.rs.core.Configuration;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.server.controller.client.rest.RestKieServerControllerClient;
import org.kie.server.controller.client.websocket.WebSocketKieServerControllerClient;

public class KieServerControllerClientFactory {
    private KieServerControllerClientFactory() {
    }

    public static KieServerControllerClient newRestClient(String controllerUrl, String login, String password) {
        return new RestKieServerControllerClient(controllerUrl, login, password);
    }

    public static KieServerControllerClient newRestClient(String controllerUrl, String login, String password, MarshallingFormat format) {
        return new RestKieServerControllerClient(controllerUrl, login, password, format);
    }

    public static KieServerControllerClient newRestClient(String controllerUrl, String login, String password, MarshallingFormat format, Configuration configuration) {
        return new RestKieServerControllerClient(controllerUrl, login, password, format, configuration);
    }

    public static KieServerControllerClient newWebSocketClient(String controllerUrl, String login, String password) {
        return new WebSocketKieServerControllerClient(controllerUrl, login, password, null, null);
    }

    public static KieServerControllerClient newWebSocketClient(String controllerUrl, String login, String password, EventHandler handler) {
        return new WebSocketKieServerControllerClient(controllerUrl, login, password, null, handler);
    }

    public static KieServerControllerClient newWebSocketClient(String controllerUrl, String token, EventHandler handler) {
        return new WebSocketKieServerControllerClient(controllerUrl, null, null, token, handler);
    }
}

