/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(KieServerInstanceManager.class);
    private static final String CONTAINERS_URI_PART = "/containers/";
    private static KieServerInstanceManager INSTANCE = new KieServerInstanceManager();

    public static KieServerInstanceManager getInstance() {
        return INSTANCE;
    }

    public List<Container> startScanner(ServerTemplate serverTemplate, final ContainerSpec containerSpec, final long interval) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(Long.valueOf(interval));
                scannerResource.setStatus(KieScannerStatus.STARTED);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner failed to start on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> stopScanner(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(null);
                scannerResource.setStatus(KieScannerStatus.STOPPED);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner failed to stop on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> scanNow(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(null);
                scannerResource.setStatus(KieScannerStatus.SCANNING);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner (scan now) failed on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> startContainer(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response;
                KieContainerResource containerResource = new KieContainerResource(containerSpec.getId(), containerSpec.getReleasedId(), container.getResolvedReleasedId(), container.getStatus());
                containerResource.setMessages((List)container.getMessages());
                if (containerSpec.getConfigs() != null) {
                    ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
                    if (containerConfig != null) {
                        RuleConfig ruleConfig = (RuleConfig)containerConfig;
                        KieScannerResource scannerResource = new KieScannerResource();
                        scannerResource.setPollInterval(ruleConfig.getPollInterval());
                        scannerResource.setStatus(ruleConfig.getScannerStatus());
                        containerResource.setScanner(scannerResource);
                    }
                    if ((containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.PROCESS)) != null) {
                        ProcessConfig processConfig = (ProcessConfig)containerConfig;
                        KieServerConfigItem configItem = new KieServerConfigItem();
                        configItem.setType("BPM");
                        configItem.setName("KBase");
                        configItem.setValue(processConfig.getKBase());
                        containerResource.addConfigItem(configItem);
                        configItem = new KieServerConfigItem();
                        configItem.setType("BPM");
                        configItem.setName("KSession");
                        configItem.setValue(processConfig.getKSession());
                        containerResource.addConfigItem(configItem);
                        configItem = new KieServerConfigItem();
                        configItem.setType("BPM");
                        configItem.setName("MergeMode");
                        configItem.setValue(processConfig.getMergeMode());
                        containerResource.addConfigItem(configItem);
                        configItem = new KieServerConfigItem();
                        configItem.setType("BPM");
                        configItem.setName("RuntimeStrategy");
                        configItem.setValue(processConfig.getRuntimeStrategy());
                        containerResource.addConfigItem(configItem);
                    }
                }
                if (!(response = client.createContainer(containerSpec.getId(), containerResource)).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Container {} failed to start on server instance {} due to {}", new Object[]{containerSpec.getId(), container.getUrl(), response.getMsg()});
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> stopContainer(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response = client.disposeContainer(containerSpec.getId());
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Container {} failed to stop on server instance {} due to {}", new Object[]{containerSpec.getId(), container.getUrl(), response.getMsg()});
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> upgradeContainer(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response = client.updateReleaseId(containerSpec.getId(), containerSpec.getReleasedId());
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Container {} failed to upgrade on server instance {} due to {}", new Object[]{containerSpec.getId(), container.getUrl(), response.getMsg()});
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> getContainers(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response;
                if (containerSpec.getStatus().equals((Object)KieContainerStatus.STARTED) && (response = client.getContainerInfo(containerSpec.getId())).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    KieContainerResource containerResource = (KieContainerResource)response.getResult();
                    container.setContainerSpecId(containerResource.getContainerId());
                    container.setContainerName(containerResource.getContainerId());
                    container.setResolvedReleasedId(containerResource.getResolvedReleaseId() == null ? containerResource.getReleaseId() : containerResource.getResolvedReleaseId());
                    container.setServerTemplateId(serverTemplate.getId());
                    container.setStatus(containerResource.getStatus());
                    container.setMessages((Collection)containerResource.getMessages());
                }
                return null;
            }
        });
    }

    public List<Container> getContainers(ServerInstanceKey serverInstanceKey) {
        ArrayList<Container> containers = new ArrayList<Container>();
        if (serverInstanceKey == null || serverInstanceKey.getUrl() == null) {
            return containers;
        }
        try {
            KieServicesClient client = this.getClient(serverInstanceKey.getUrl());
            ServiceResponse response = client.listContainers();
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                KieContainerResourceList resourceList = (KieContainerResourceList)response.getResult();
                for (KieContainerResource containerResource : resourceList.getContainers()) {
                    Container container = new Container();
                    container.setContainerSpecId(containerResource.getContainerId());
                    container.setContainerName(containerResource.getContainerId());
                    container.setServerInstanceId(serverInstanceKey.getServerInstanceId());
                    container.setUrl(serverInstanceKey.getUrl() + CONTAINERS_URI_PART + containerResource.getContainerId());
                    container.setResolvedReleasedId(containerResource.getResolvedReleaseId() == null ? containerResource.getReleaseId() : containerResource.getResolvedReleaseId());
                    container.setServerTemplateId(serverInstanceKey.getServerTemplateId());
                    container.setStatus(containerResource.getStatus());
                    container.setMessages((Collection)containerResource.getMessages());
                    containers.add(container);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get list of containers from remote server at url {} due to {}", (Object)serverInstanceKey.getUrl(), (Object)e.getMessage());
        }
        return containers;
    }

    protected List<Container> callRemoteKieServerOperation(ServerTemplate serverTemplate, ContainerSpec containerSpec, RemoteKieServerOperation operation) {
        ArrayList<Container> containers = new ArrayList<Container>();
        if (serverTemplate.getServerInstanceKeys() == null || serverTemplate.getServerInstanceKeys().isEmpty()) {
            return containers;
        }
        for (ServerInstanceKey instanceUrl : serverTemplate.getServerInstanceKeys()) {
            Container container = new Container();
            container.setContainerSpecId(containerSpec.getId());
            container.setServerTemplateId(serverTemplate.getId());
            container.setServerInstanceId(instanceUrl.getServerInstanceId());
            container.setUrl(instanceUrl.getUrl() + CONTAINERS_URI_PART + containerSpec.getId());
            container.setResolvedReleasedId(containerSpec.getReleasedId());
            container.setStatus(containerSpec.getStatus());
            try {
                KieServicesClient client = this.getClient(instanceUrl.getUrl());
                operation.doOperation(client, container);
            }
            catch (Exception e) {
                logger.debug("Unable to connect to {}", (Object)instanceUrl);
            }
            containers.add(container);
        }
        return containers;
    }

    public boolean isAlive(ServerInstanceKey serverInstanceKey) {
        boolean alive = false;
        try {
            this.getClient(serverInstanceKey.getUrl());
            alive = true;
        }
        catch (Exception e) {
            logger.debug("Unable to connect to server instance at {} due to {}", (Object)serverInstanceKey.getUrl(), (Object)e.getMessage());
        }
        return alive;
    }

    protected KieServicesClient getClient(String url) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)url, (String)this.getUser(), (String)this.getPassword());
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        String authToken = this.getToken();
        if (authToken != null && !authToken.isEmpty()) {
            configuration.setCredentialsProvider((CredentialsProvider)new EnteredTokenCredentialsProvider(authToken));
        }
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        return kieServicesClient;
    }

    protected void collectContainerInfo(ContainerSpec containerSpec, KieServicesClient client, Container container) {
        ServiceResponse serviceResponse = client.getContainerInfo(containerSpec.getId());
        if (serviceResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
            KieContainerResource containerResource = (KieContainerResource)serviceResponse.getResult();
            container.setMessages((Collection)containerResource.getMessages());
        }
    }

    protected String getUser() {
        return System.getProperty("org.kie.server.user", "kieserver");
    }

    protected String getPassword() {
        return System.getProperty("org.kie.server.pwd", "kieserver1!");
    }

    protected String getToken() {
        return System.getProperty("org.kie.server.token");
    }

    protected class RemoteKieServerOperation<T> {
        protected RemoteKieServerOperation() {
        }

        public T doOperation(KieServicesClient client, Container container) {
            return null;
        }
    }
}

