/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.OnClose;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.KieServerMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketKieServerControllerClient
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketKieServerControllerClient.class);
    public static final String AUTHORIZATION = "Authorization";
    private WebSocketContainer container = null;
    private Session session = null;
    private String controllerUrl = null;
    private KieServerConfig config = null;
    private KieServerMessageHandler messageHandler;
    private AtomicBoolean closed = new AtomicBoolean(true);
    private Thread reconnectThread = null;
    private Consumer<WebsocketKieServerControllerClient> onReconnect;

    public WebsocketKieServerControllerClient(Consumer<WebsocketKieServerControllerClient> onReconnect) {
        this.onReconnect = onReconnect;
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        if (!session.getId().equals(this.session.getId())) {
            logger.info("Session closed does not match this session... ignoring");
            return;
        }
        logger.info("Session {} is closed due to {}", (Object)session.getId(), (Object)reason);
        if (!this.closed.get()) {
            this.reconnectThread = new Thread(() -> {
                while (!session.isOpen()) {
                    try {
                        logger.debug("Waiting 10 seconds before attempting to reconnect to controller {}", (Object)this.controllerUrl);
                        Thread.sleep(10000L);
                        this.init(this.controllerUrl, this.config);
                        this.onReconnect.accept(this);
                        break;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (RuntimeException e) {
                        logger.warn("Unable to reconnect to controller over websocket {} due to {}", (Object)this.controllerUrl, (Object)e.getMessage());
                    }
                }
            }, "Kie Server - Websocket reconnect");
            this.reconnectThread.start();
        }
    }

    public void init(String controllerUrl, final KieServerConfig config) {
        this.config = config;
        this.controllerUrl = controllerUrl;
        try {
            if (this.container == null) {
                this.container = ContainerProvider.getWebSocketContainer();
            }
            this.session = this.container.connectToServer((Endpoint)this, new ClientEndpointConfig(){

                public Map<String, Object> getUserProperties() {
                    return Collections.emptyMap();
                }

                public List<Class<? extends Encoder>> getEncoders() {
                    return Collections.emptyList();
                }

                public List<Class<? extends Decoder>> getDecoders() {
                    return Collections.emptyList();
                }

                public List<String> getPreferredSubprotocols() {
                    return Collections.emptyList();
                }

                public List<Extension> getExtensions() {
                    return Collections.emptyList();
                }

                public ClientEndpointConfig.Configurator getConfigurator() {
                    return new ClientEndpointConfig.Configurator(){

                        public void beforeRequest(Map<String, List<String>> headers) {
                            super.beforeRequest(headers);
                            String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                            String password = config.getConfigItemValue("org.kie.server.controller.pwd", "kieserver1!");
                            String token = config.getConfigItemValue("org.kie.server.controller.token");
                            if (token != null && !token.isEmpty()) {
                                headers.put(WebsocketKieServerControllerClient.AUTHORIZATION, Arrays.asList("Bearer " + token));
                            } else {
                                try {
                                    headers.put(WebsocketKieServerControllerClient.AUTHORIZATION, Arrays.asList("Basic " + Base64.getEncoder().encodeToString((userName + ':' + password).getBytes("UTF-8"))));
                                }
                                catch (UnsupportedEncodingException e) {
                                    logger.warn(e.getMessage());
                                }
                            }
                        }
                    };
                }
            }, URI.create(controllerUrl));
            this.messageHandler = new KieServerMessageHandler(this.session);
            this.closed.set(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.closed.set(true);
        if (this.reconnectThread != null) {
            this.reconnectThread.interrupt();
        }
        try {
            this.messageHandler = null;
            this.session.close();
        }
        catch (IOException e) {
            logger.warn("Unexpected error while closing websocket connection to controller", (Throwable)e);
        }
    }

    public void sendWithHandler(String content, InternalMessageHandler handler) throws IOException {
        if (!this.session.isOpen()) {
            throw new RuntimeException("No connection to controller");
        }
        this.messageHandler.addHandler(handler);
        this.session.getBasicRemote().sendText(content);
    }

    public boolean isActive() {
        return this.session != null && this.session.isOpen();
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.info("Connection to Kie Controller over websocket is now open with session id " + session.getId());
    }

    public void onError(Session session, Throwable thr) {
        logger.error("Error received {} on session {}", new Object[]{thr.getMessage(), session.getId(), thr});
    }
}

