/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMessageHandler
implements MessageHandler.Whole<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerMessageHandler.class);
    private ArrayDeque<InternalMessageHandler> internalHandlers = new ArrayDeque();
    private Session session;

    public KieServerMessageHandler(Session session) {
        this.session = session;
    }

    public void onMessage(String message) {
        LOGGER.debug("Message received on session id: '{}'", (Object)this.session.getId());
        LOGGER.debug("Message content '{}'", (Object)message);
        InternalMessageHandler handler = this.internalHandlers.poll();
        LOGGER.debug("About to handle message with handler {}", (Object)handler);
        if (handler == null) {
            LOGGER.warn("No message handler available to process message");
            throw new RuntimeException("No message handler available to process message");
        }
        String response = handler.onMessage(message);
        LOGGER.debug("Response to be send (if not null) is '{}'", (Object)response);
        this.addHandler(handler.getNextHandler());
        if (response != null) {
            try {
                this.session.getBasicRemote().sendText(response);
                LOGGER.debug("Response successfully sent");
                handler.afterResponseSent();
            }
            catch (IOException e) {
                LOGGER.error("Error when sending response", (Throwable)e);
            }
        }
    }

    public void addHandler(InternalMessageHandler handler) {
        if (handler != null) {
            LOGGER.debug("Adding message handler {} to session {}", (Object)handler, (Object)this.session.getId());
            this.internalHandlers.add(handler);
        }
    }
}

