/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.auth;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketAuthConfigurator
extends ClientEndpointConfig.Configurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketAuthConfigurator.class);
    private static final String AUTHORIZATION = "Authorization";
    private final String userName;
    private final String password;
    private final String token;

    public WebSocketAuthConfigurator(String userName, String password, String token) {
        this.userName = userName;
        this.password = password;
        this.token = token;
    }

    public void beforeRequest(Map<String, List<String>> headers) {
        super.beforeRequest(headers);
        if (this.token != null && !this.token.isEmpty()) {
            headers.put(AUTHORIZATION, Arrays.asList("Bearer " + this.token));
        } else {
            try {
                headers.put(AUTHORIZATION, Arrays.asList("Basic " + Base64.getEncoder().encodeToString((this.userName + ':' + this.password).getBytes("UTF-8"))));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

