/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;

public class WebSocketServiceResponse
extends ServiceResponse
implements InternalMessageHandler {
    private CountDownLatch latch;
    private ServiceResponse<?> result;
    private Function<String, ServiceResponse<?>> handler;

    public WebSocketServiceResponse(boolean isBlocking, Function<String, ServiceResponse<?>> handler) {
        this.handler = handler;
        if (isBlocking) {
            this.latch = new CountDownLatch(1);
        }
    }

    public ServiceResponse.ResponseType getType() {
        this.waitIfNeeded();
        return this.result.getType();
    }

    public String getMsg() {
        this.waitIfNeeded();
        return this.result.getMsg();
    }

    public Object getResult() {
        this.waitIfNeeded();
        return this.result.getResult();
    }

    @Override
    public String onMessage(String message) {
        this.result = this.handler.apply(message);
        if (this.latch != null) {
            this.latch.countDown();
        }
        return null;
    }

    protected void waitIfNeeded() {
        if (this.latch != null) {
            try {
                this.latch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

