/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket;

import java.util.Collections;
import java.util.ServiceLoader;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.websocket.ConnectedKieServerHandler;
import org.kie.server.controller.websocket.WebSocketSessionManager;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket/controller/{server-id}")
public class WebSocketKieServerControllerImpl
extends KieServerControllerImpl {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketKieServerControllerImpl.class);
    private WebSocketSessionManager manager = WebSocketSessionManager.getInstance();
    @Inject
    private Instance<KieServerTemplateStorage> templateStorage;
    @Inject
    private Instance<NotificationService> notificationService;

    public WebSocketKieServerControllerImpl() {
        ServiceLoader<PersistingServerTemplateStorageService> storageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (storageServices != null && storageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = storageServices.iterator().next();
            this.setTemplateStorage(storageService.getTemplateStorage());
            logger.debug("Server template storage for standalone kie server controller is {}", (Object)storageService.getTemplateStorage().toString());
        } else {
            logger.debug("No server template storage defined. Default storage: InMemoryKieServerTemplateStorage will be used");
        }
    }

    @PostConstruct
    public void configure() {
        try {
            this.setTemplateStorage((KieServerTemplateStorage)this.templateStorage.get());
        }
        catch (RuntimeException e) {
            logger.warn("Unable to find template storage implementation, using in memory");
        }
        try {
            this.setNotificationService((NotificationService)this.notificationService.get());
        }
        catch (RuntimeException e) {
            logger.warn("Unable to find notification service implementation, using logging only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void onKieServerConnect(@PathParam(value="server-id") String serverId, Session session) {
        WebSocketSessionManager webSocketSessionManager = this.manager;
        synchronized (webSocketSessionManager) {
            this.manager.addSession(session);
            this.manager.getHandler(session.getId()).addHandler((InternalMessageHandler)new ConnectedKieServerHandler(this.manager, session, this, serverId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onKieServerDisconnect(@PathParam(value="server-id") String serverId, Session session, CloseReason closeReason) {
        WebSocketSessionManager webSocketSessionManager = this.manager;
        synchronized (webSocketSessionManager) {
            String url = this.manager.removeSession(session);
            if (url != null) {
                KieServerInfo serverInfo = new KieServerInfo(serverId, "", "", Collections.emptyList(), url);
                this.disconnect(serverInfo);
                logger.info("Server with id '{}' disconnected", (Object)serverId);
            }
        }
    }

    @OnError
    public void onKieServerError(Session session, Throwable e) {
        logger.error("Unexpected error", e);
    }

    protected void notifyOnConnect(ServerInstance serverInstance) {
    }
}

