/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.websocket.common.handlers.KieServerMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private ConcurrentMap<String, Session> availableSessionsById = new ConcurrentHashMap<String, Session>();
    private ConcurrentMap<String, List<Session>> availableSessionsByUrl = new ConcurrentHashMap<String, List<Session>>();
    private ConcurrentMap<String, KieServerInfo> sessionToUrl = new ConcurrentHashMap<String, KieServerInfo>();
    private ConcurrentMap<String, KieServerMessageHandler> handlersPerSession = new ConcurrentHashMap<String, KieServerMessageHandler>();
    private static WebSocketSessionManager INSTANCE = new WebSocketSessionManager();

    public static WebSocketSessionManager getInstance() {
        return INSTANCE;
    }

    public void addSession(Session session) {
        this.availableSessionsById.put(session.getId(), session);
        KieServerMessageHandler messageHandler = new KieServerMessageHandler(session);
        this.handlersPerSession.put(session.getId(), messageHandler);
        session.addMessageHandler((MessageHandler)messageHandler);
        logger.debug("Session '{}' added to Web Socket manager", (Object)session.getId());
    }

    public void addSession(KieServerInfo serverInfo, Session session) {
        ArrayList<Session> newSessions = new ArrayList<Session>();
        ArrayList<Session> sessions = this.availableSessionsByUrl.putIfAbsent(serverInfo.getLocation(), newSessions);
        if (sessions == null) {
            sessions = newSessions;
        }
        sessions.add(session);
        this.sessionToUrl.put(session.getId(), serverInfo);
        logger.debug("Session '{}' associated with url: {}", (Object)session.getId(), (Object)serverInfo.getLocation());
    }

    public String removeSession(Session session) {
        this.availableSessionsById.remove(session.getId());
        KieServerInfo serverInfo = (KieServerInfo)this.sessionToUrl.remove(session.getId());
        List sessions = (List)this.availableSessionsByUrl.get(serverInfo.getLocation());
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            Session s = (Session)it.next();
            if (!s.getId().equals(session.getId())) continue;
            it.remove();
            break;
        }
        this.handlersPerSession.remove(session.getId());
        logger.debug("Session '{}' removed to Web Socket manager", (Object)session.getId());
        if (((List)this.availableSessionsByUrl.get(serverInfo.getLocation())).isEmpty()) {
            return serverInfo.getLocation();
        }
        return null;
    }

    public List<Session> getByUrl(String url) {
        List sessions = (List)this.availableSessionsByUrl.get(url);
        if (sessions == null) {
            return Collections.emptyList();
        }
        return sessions.stream().filter(s -> s.isOpen()).collect(Collectors.toList());
    }

    public KieServerInfo getServerInfoByUrl(String url) {
        String sessionId = this.getByUrl(url).get(0).getId();
        return (KieServerInfo)this.sessionToUrl.get(sessionId);
    }

    public KieServerMessageHandler getHandler(String sessionId) {
        return (KieServerMessageHandler)this.handlersPerSession.get(sessionId);
    }

    public void close() {
        this.availableSessionsById.values().forEach(session -> {
            if (session.isOpen()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Server is going down"));
                }
                catch (Exception e) {
                    logger.warn("Unexpected error while shutting down Web Socket session", (Throwable)e);
                }
            }
        });
    }
}

