/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.util.List;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.websocket.notification.WebSocketNotificationSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketNotificationService
implements NotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketNotificationService.class);
    private static WebSocketNotificationService INSTANCE = new WebSocketNotificationService();

    protected WebSocketNotificationService() {
        LOGGER.info("WebSocket Notification Service started.");
    }

    public static WebSocketNotificationService getInstance() {
        return INSTANCE;
    }

    private void notifySessions(KieServerControllerEvent event) {
        KieServerControllerNotification notification = new KieServerControllerNotification(event);
        LOGGER.debug("Sending notification to all Web Socket sessions");
        WebSocketNotificationSessionManager.getInstance().getSessions().forEach(session -> {
            LOGGER.debug("Sending notification to Web Socket session with id: {}", (Object)session.getId());
            session.getAsyncRemote().sendObject((Object)notification, result -> {
                if (result.isOK()) {
                    LOGGER.debug("Notification sent to session with id: {}", (Object)session.getId());
                } else {
                    LOGGER.warn("Failed to send notification, error: {}", (Object)result.getException().getMessage(), (Object)result.getException());
                }
            });
        });
    }

    public void notify(ServerTemplate serverTemplate, ContainerSpec containerSpec, List<Container> containers) {
        LOGGER.info("WebSocket notification about change requested on server {} with container spec {} with following result {}", new Object[]{serverTemplate, containerSpec, containers});
        this.notifySessions((KieServerControllerEvent)new ContainerSpecUpdated(serverTemplate, containerSpec, containers));
    }

    public void notify(ServerTemplateUpdated serverTemplateUpdated) {
        LOGGER.info("WebSocket notify on updated :: {}", (Object)serverTemplateUpdated);
        this.notifySessions((KieServerControllerEvent)serverTemplateUpdated);
    }

    public void notify(ServerTemplateDeleted serverTemplateDeleted) {
        LOGGER.info("WebSocket notify on deleted :: {}", (Object)serverTemplateDeleted);
        this.notifySessions((KieServerControllerEvent)serverTemplateDeleted);
    }

    public void notify(ServerInstanceUpdated serverInstanceUpdated) {
        LOGGER.info("WebSocket notify on instance updated :: {}", (Object)serverInstanceUpdated);
        this.notifySessions((KieServerControllerEvent)serverInstanceUpdated);
    }

    public void notify(ServerInstanceDeleted serverInstanceDeleted) {
        LOGGER.info("WebSocket notify on instance deleted :: {}", (Object)serverInstanceDeleted);
        this.notifySessions((KieServerControllerEvent)serverInstanceDeleted);
    }

    public void notify(ServerInstanceConnected serverInstanceConnected) {
        LOGGER.info("WebSocket notify on instance connected :: {}", (Object)serverInstanceConnected);
        this.notifySessions((KieServerControllerEvent)serverInstanceConnected);
    }

    public void notify(ServerInstanceDisconnected serverInstanceDisconnected) {
        LOGGER.info("WebSocket notify on instance disconnected :: {}", (Object)serverInstanceDisconnected);
        this.notifySessions((KieServerControllerEvent)serverInstanceDisconnected);
    }
}

