/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.generator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.generator.CasePrefixCannotBeGeneratedException;
import org.jbpm.casemgmt.api.generator.CasePrefixNotFoundException;
import org.kie.server.generator.CustomCaseIdExpressionFunctions;
import org.mvel2.CompileException;
import org.mvel2.templates.TemplateRuntime;

public class CustomNumberPrefixCaseIdGenerator
implements CaseIdGenerator {
    private static final String IDENTIFIER = "CUSTOM_NUMBER_PREFIX";
    private static final String CUSTOM_PREFIX = "01234";
    private static ConcurrentMap<String, AtomicLong> caseIdMap = new ConcurrentHashMap<String, AtomicLong>();

    public String generate(String prefix, Map<String, Object> optionalParameters) {
        if (!caseIdMap.containsKey(prefix)) {
            throw new CasePrefixNotFoundException("Case id prefix \"" + prefix + "\" not found.");
        }
        long nextVal = ((AtomicLong)caseIdMap.get(prefix)).incrementAndGet();
        String paddedNumber = String.format("%05d", nextVal);
        return prefix + "-" + CUSTOM_PREFIX + paddedNumber;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public void register(String prefix) {
        caseIdMap.putIfAbsent(prefix, new AtomicLong(0L));
    }

    public void unregister(String prefix) {
        caseIdMap.remove(prefix);
    }

    public String resolveCaseIdPrefix(String expression, Map<String, Object> optionalParameters) {
        try {
            return !expression.isEmpty() ? (String)TemplateRuntime.eval((String)expression, (Object)CustomCaseIdExpressionFunctions.CASE_ID_FUNCTIONS, optionalParameters) : "";
        }
        catch (CompileException e) {
            throw new CasePrefixCannotBeGeneratedException("Case Id Prefix cannot be generated", (Throwable)e);
        }
    }
}

