/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.jms;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.jms.JMSRuntimeException;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransactionManagement(value=TransactionManagementType.BEAN)
@MessageDriven(name="KieServerMDB", activationConfig={@ActivationConfigProperty(propertyName="destinationJndiName", propertyValue="queue/KIE.SERVER.REQUEST"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/KIE.SERVER.REQUEST"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class KieServerMDB
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(KieServerMDB.class);
    private String RESPONSE_QUEUE_NAME = null;
    private static final String RESPONSE_QUEUE_NAME_PROPERTY = "kie.server.jms.queues.response";
    private static final String DEFAULT_RESPONSE_QUEUE_NAME = "queue/KIE.SERVER.RESPONSE";
    private static final String ID_NECESSARY = "This id is needed to be able to match a request to a response message.";
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    private Session session;
    private Connection connection;
    private KieServerImpl kieServer;
    private Map<MarshallingFormat, Marshaller> marshallers;

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty(RESPONSE_QUEUE_NAME_PROPERTY, DEFAULT_RESPONSE_QUEUE_NAME);
        try {
            this.connection = this.factory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.connection.start();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to open new session to send response messages";
            logger.error(errMsg, (Throwable)jmse);
            throw new JMSRuntimeException(errMsg, jmse);
        }
        this.kieServer = KieServerLocator.getInstance();
        this.marshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();
        ClassLoader classLoader = CommandScript.class.getClassLoader();
        this.marshallers.put(MarshallingFormat.XSTREAM, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)classLoader));
        this.marshallers.put(MarshallingFormat.JAXB, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)classLoader));
        this.marshallers.put(MarshallingFormat.JSON, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)classLoader));
    }

    @PreDestroy
    public void cleanup() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to close " + (this.connection == null ? "session" : "connection");
            logger.error(errMsg, (Throwable)jmse);
            throw new JMSRuntimeException(errMsg, jmse);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void onMessage(Message message) {
        KieServerExtension extension;
        KieContainerCommandService executor = null;
        Iterator i$ = this.kieServer.getServerExtensions().iterator();
        while (i$.hasNext() && (executor = (KieContainerCommandService)(extension = (KieServerExtension)i$.next()).getAppComponents(KieContainerCommandService.class)) == null) {
        }
        if (executor == null) {
            throw new IllegalStateException("No executor found for script execution");
        }
        String msgCorrId = null;
        try {
            msgCorrId = message.getJMSCorrelationID();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        MarshallingFormat format = null;
        String classType = null;
        try {
            classType = message.getStringProperty("kie_class_type");
            if (!message.propertyExists("serialization_format")) {
                format = MarshallingFormat.JAXB;
            } else {
                int intFormat = message.getIntProperty("serialization_format");
                logger.debug("Serialization format (int) is " + intFormat);
                format = MarshallingFormat.fromId((int)intFormat);
                logger.debug("Serialization format is " + format);
                if (format == null) {
                    String errMsg = "Unsupported marshalling format '" + intFormat + "' from message " + msgCorrId + ".";
                    throw new JMSRuntimeException(errMsg);
                }
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve property 'serialization_format' from message " + msgCorrId + ".";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        Marshaller marshaller = this.marshallers.get(format);
        logger.debug("Selected marshaller is " + marshaller);
        CommandScript script = KieServerMDB.unmarshallRequest(message, msgCorrId, marshaller, format);
        ServiceResponsesList response = executor.executeScript(script, format, classType);
        Message msg = KieServerMDB.marshallResponse(this.session, msgCorrId, format, marshaller, response);
        this.sendResponse(msgCorrId, format, msg);
    }

    private static CommandScript unmarshallRequest(Message message, String msgId, Marshaller serializationProvider, MarshallingFormat format) {
        CommandScript cmdMsg = null;
        try {
            String msgStrContent = ((TextMessage)message).getText();
            logger.info("About to unmarshal content '{}'", (Object)msgStrContent);
            cmdMsg = (CommandScript)serializationProvider.unmarshall(msgStrContent, CommandScript.class);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to read information from message " + msgId + ".";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to unmarshall request to " + CommandScript.class.getSimpleName() + " [msg id: " + msgId + "].";
            throw new JMSRuntimeException(errMsg, e);
        }
        return cmdMsg;
    }

    private static Message marshallResponse(Session session, String msgId, MarshallingFormat format, Marshaller marshaller, ServiceResponsesList response) {
        TextMessage textMsg = null;
        try {
            String msgStr = marshaller.marshall((Object)response);
            textMsg = session.createTextMessage(msgStr);
            textMsg.setIntProperty("serialization_format", format.getId());
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to create response message or write to it [msg id: " + msgId + "].";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize " + response.getClass().getSimpleName() + " to a String.";
            throw new JMSRuntimeException(errMsg, e);
        }
        return textMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(String msgCorrId, MarshallingFormat format, Message msg) {
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to set correlation id of response to msg id " + msgCorrId;
            logger.error(errMsg, (Throwable)jmse);
            return;
        }
        MessageProducer producer = null;
        try {
            Queue responseQueue = (Queue)new InitialContext().lookup(this.RESPONSE_QUEUE_NAME);
            producer = this.session.createProducer((Destination)responseQueue);
            producer.send(msg);
        }
        catch (NamingException ne) {
            String errMsg = "Unable to lookup response queue " + this.RESPONSE_QUEUE_NAME + " to send msg " + msgCorrId + " (Is " + RESPONSE_QUEUE_NAME_PROPERTY + " incorrect?).";
            logger.error(errMsg, (Throwable)ne);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME;
            logger.error(errMsg, (Throwable)jmse);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.debug("Closing the producer resulted in an exception: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

