/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.jms.executor;

import javax.annotation.PostConstruct;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.kie.api.executor.ExecutorService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="AvailableJobsExecutor")
@TransactionManagement(value=TransactionManagementType.BEAN)
public class PollExecutorBean
extends AvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PollExecutorBean.class);
    private boolean active = true;
    private KieServerImpl kieServer;

    @PostConstruct
    public void init() {
        this.kieServer = KieServerLocator.getInstance();
        KieServerExtension bpmServerExtension = null;
        for (KieServerExtension extension : this.kieServer.getServerRegistry().getServerExtensions()) {
            if (!extension.isActive() || !"BPM".equals(extension.getImplementedCapability())) continue;
            bpmServerExtension = extension;
        }
        if (bpmServerExtension == null) {
            logger.warn("No BPM capability found on the server, PollExecutorBean is deactivated");
            this.active = false;
            return;
        }
        ExecutorService executorService = (ExecutorService)bpmServerExtension.getAppComponents(ExecutorService.class);
        if (executorService == null) {
            logger.warn("Unable to find ExecutorService within {} extension, deactivating PollExecutorBean", bpmServerExtension);
            this.active = false;
            return;
        }
        this.setClassCacheManager(new ClassCacheManager());
        this.setQueryService(((ExecutorServiceImpl)executorService).getQueryService());
        this.setExecutorStoreService(((ExecutorImpl)((ExecutorServiceImpl)executorService).getExecutor()).getExecutorStoreService());
    }

    @Asynchronous
    public void executeJob() {
        if (!this.active) {
            logger.warn("PollExecutor is not active due to startup errors");
        }
        super.executeJob();
    }
}

