/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.jms.executor;

import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.jms.JmsAvailableJobsExecutor;
import org.kie.api.executor.ExecutorService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransactionManagement(value=TransactionManagementType.BEAN)
@MessageDriven(name="KieExecutorMDB", activationConfig={@ActivationConfigProperty(propertyName="destination", propertyValue="queue/KIE.SERVER.EXECUTOR"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class KieExecutorMDB
extends JmsAvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(KieExecutorMDB.class);
    private boolean active = true;
    private KieServerImpl kieServer;

    @PostConstruct
    public void init() {
        this.kieServer = KieServerLocator.getInstance();
        KieServerExtension bpmServerExtension = null;
        for (KieServerExtension extension : this.kieServer.getServerRegistry().getServerExtensions()) {
            if (!extension.isActive() || !"BPM".equals(extension.getImplementedCapability())) continue;
            bpmServerExtension = extension;
        }
        if (bpmServerExtension == null) {
            logger.warn("No BPM capability found on the server, ExecutorMDB is deactivated");
            this.active = false;
            return;
        }
        ExecutorService executorService = (ExecutorService)bpmServerExtension.getAppComponents(ExecutorService.class);
        if (executorService == null) {
            logger.warn("Unable to find ExecutorService within {} extension, deactivating ExecutorMDB", bpmServerExtension);
            this.active = false;
            return;
        }
        this.setClassCacheManager(new ClassCacheManager());
        this.setQueryService(((ExecutorServiceImpl)executorService).getQueryService());
        this.setExecutorStoreService(((ExecutorImpl)((ExecutorServiceImpl)executorService).getExecutor()).getExecutorStoreService());
        this.setExecutor(((ExecutorServiceImpl)executorService).getExecutor());
        this.setEventSupport(((ExecutorServiceImpl)executorService).getEventSupport());
    }

    public void onMessage(Message message) {
        if (!this.active) {
            throw new RuntimeException("ExecutorMDB is not active most likely due to missing KieServer capabilities, check startup logs");
        }
        super.onMessage(message);
    }
}

