/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import java.text.MessageFormat;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.casemgmt.api.CaseActiveException;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.kie.server.remote.rest.casemgmt.CaseOperation;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCaseResource.class);
    protected CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase;
    protected KieServerRegistry context;

    public AbstractCaseResource() {
    }

    public AbstractCaseResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        this.caseManagementRuntimeDataServiceBase = caseManagementRuntimeDataServiceBase;
        this.context = context;
    }

    protected Response invokeCaseOperation(HttpHeaders headers, String containerId, String caseId, CaseOperation operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            return operation.invoke(v, type, conversationIdHeader);
        }
        catch (CaseActiveException e) {
            return RestUtils.alreadyExists((String)MessageFormat.format("Case with id \"{0}\" is already started/reopened", caseId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (CaseNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find case instance \"{0}\"", caseId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Container not found with id \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing request \"{0}\"", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

