/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kie.server.remote.rest.casemgmt.CaseQueryResource;
import org.kie.server.remote.rest.casemgmt.CaseResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.casemgmt.CaseManagementServiceBase;

public class CaseRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "Case-Mgmt";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        CaseManagementServiceBase caseManagementServiceBase = null;
        CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase = null;
        KieServerRegistry context = null;
        for (Object object : services) {
            if (object == null) continue;
            if (CaseManagementServiceBase.class.isAssignableFrom(object.getClass())) {
                caseManagementServiceBase = (CaseManagementServiceBase)object;
                continue;
            }
            if (CaseManagementRuntimeDataServiceBase.class.isAssignableFrom(object.getClass())) {
                caseManagementRuntimeDataServiceBase = (CaseManagementRuntimeDataServiceBase)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(new CaseResource(caseManagementServiceBase, caseManagementRuntimeDataServiceBase, context));
        components.add(new CaseQueryResource(caseManagementRuntimeDataServiceBase, context));
        return components;
    }
}

