/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/queries/cases")
public class CaseQueryResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseQueryResource.class);

    public CaseQueryResource() {
    }

    public CaseQueryResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
    }

    @GET
    @Path(value="instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstances(@Context HttpHeaders headers, @QueryParam(value="owner") String owner, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseInstanceList responseObject = null;
            if (owner != null && !owner.isEmpty()) {
                logger.debug("About to look for case instances owned by {} with status {}", (Object)owner, (Object)status);
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesOwnedBy(owner, status, page, pageSize, sort, sortOrder);
            } else {
                logger.debug("About to look for case instances with status {}", (Object)status);
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesAnyRole(status, page, pageSize, sort, sortOrder);
            }
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="{caseRoleName}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstancesByRole(@Context HttpHeaders headers, @PathParam(value="caseRoleName") String roleName, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instances with status {}", (Object)status);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByRole(roleName, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseDefinitions(@Context HttpHeaders headers, @QueryParam(value="filter") String filter, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definitions with filter {}", (Object)filter);
            CaseDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinitions(filter, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="processes")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessDefinitions(@Context HttpHeaders headers, @QueryParam(value="filter") String filter, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for process definitions with filter {}", (Object)filter);
            ProcessDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessDefinitions(filter, null, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="{id}/processes")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessDefinitionsByContainer(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for process definitions with container id {}", (Object)containerId);
            ProcessDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessDefinitions(null, containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/tasks/instances/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceTasksAsPotentialOwner(@Context HttpHeaders headers, @PathParam(value="caseId") String caseId, @QueryParam(value="user") String user, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to potential owner {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasks(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/tasks/instances/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceTasksAsAdmin(@Context HttpHeaders headers, @PathParam(value="caseId") String caseId, @QueryParam(value="user") String user, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to business admin {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasksAsBusinessAdmin(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/tasks/instances/stakeholders")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceTasksAsStakeholder(@Context HttpHeaders headers, @PathParam(value="caseId") String caseId, @QueryParam(value="user") String user, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to stakeholder {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasksAsStakeholder(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }
}

