/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.casemgmt.api.CaseCommentNotFoundException;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseCommentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseRoleAssignmentList;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.casemgmt.CaseManagementServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/cases")
public class CaseResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseResource.class);
    private CaseManagementServiceBase caseManagementServiceBase;

    public CaseResource() {
    }

    public CaseResource(CaseManagementServiceBase caseManagementServiceBase, CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
        this.caseManagementServiceBase = caseManagementServiceBase;
    }

    @POST
    @Path(value="{caseDefId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response startCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseDefId") String caseDefId, String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            String response = this.caseManagementServiceBase.startCase(containerId, caseDefId, payload, type);
            logger.debug("Returning CREATED response for start case with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="withData") @DefaultValue(value="false") boolean withData, @QueryParam(value="withRoles") @DefaultValue(value="false") boolean withRoles, @QueryParam(value="withMilestones") @DefaultValue(value="false") boolean withMilestones, @QueryParam(value="withStages") @DefaultValue(value="false") boolean withStages) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            String response = this.caseManagementServiceBase.getCaseInstance(containerId, caseId, withData, withRoles, withMilestones, withStages, type);
            logger.debug("Returning OK response for get case instance with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @DELETE
    @Path(value="instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelCaseInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="destroy") @DefaultValue(value="false") boolean destroy) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.cancelCaseInstance(containerId, caseId, destroy);
            logger.debug("Returning NO CONTENT response after cancelling a case with id {}", (Object)caseId);
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @PUT
    @Path(value="{caseDefId}/instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response reopenCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseDefId") String caseDefId, @PathParam(value="caseId") String caseId, String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.reopenCase(caseId, containerId, caseDefId, payload, type);
            logger.debug("Returning CREATED response for reopen case {}", (Object)caseId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceData(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileData(containerId, caseId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceDataByName(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="dataId") String caseDataName) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileDataByName(containerId, caseId, caseDataName, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response putCaseInstanceData(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileData(containerId, caseId, payload, type);
            logger.debug("Returning OK response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Produces(value={"application/xml", "application/json"})
    public Response putCaseInstanceDataByName(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="dataId") String caseDataName, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileDataByName(containerId, caseId, caseDataName, payload, type);
            logger.debug("Returning OK response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @DELETE
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteCaseInstanceData(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="dataId") List<String> variableNames) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            if (variableNames == null || variableNames.isEmpty()) {
                return RestUtils.notFound((String)"Variable names to remove from case file not provided", (Variant)v, (Header[])customHeaders);
            }
            logger.debug("About to remove case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.removeCaseFileDataByName(containerId, caseId, variableNames);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/tasks")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task to case {}", (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, null, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseStageId") String stageId, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, stageId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="pId") String processId, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess {} in case {}", (Object)processId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, null, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseStageId") String stageId, @PathParam(value="pId") String processId, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, stageId, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @PUT
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks/{nodeName}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerAdHocNodeInStage(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseStageId") String stageId, @PathParam(value="nodeName") String adHocName, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in stage {} and in case {}", new Object[]{adHocName, stageId, caseId});
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, stageId, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @PUT
    @Path(value="instances/{caseId}/tasks/{nodeName}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerAdHocNode(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="nodeName") String adHocName, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in case {}", (Object)adHocName, (Object)caseId);
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, null, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/milestones")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceMilestones(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="achievedOnly") @DefaultValue(value="true") boolean achievedOnly, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for milestones in case {} achieved only = {}", (Object)caseId, (Object)achievedOnly);
            CaseMilestoneList responseObject = this.caseManagementRuntimeDataServiceBase.getMilestones(containerId, caseId, achievedOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/stages")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceStages(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for stages in case {} active only = {}", (Object)caseId, (Object)activeOnly);
            CaseStageList responseObject = this.caseManagementRuntimeDataServiceBase.getStages(containerId, caseId, activeOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/adhocfragments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceAdHocFragments(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for adhoc fragments in case {}", (Object)caseId);
            CaseAdHocFragmentList responseObject = this.caseManagementRuntimeDataServiceBase.getAdHocFragments(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/processes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="status") List<Integer> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            ArrayList<Integer> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<Integer>();
                actualStatus.add(1);
            }
            logger.debug("About to look for process instances in case {} with status {}", (Object)caseId, actualStatus);
            ProcessInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessInstancesForCase(containerId, caseId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/nodes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceActiveNodes(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="completed") @DefaultValue(value="false") Boolean completed, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for active nodes in case {}", (Object)caseId);
            NodeInstanceList responseObject = null;
            responseObject = completed != false ? this.caseManagementRuntimeDataServiceBase.getCompletedNodes(containerId, caseId, page, pageSize) : this.caseManagementRuntimeDataServiceBase.getActiveNodes(containerId, caseId, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/roles")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceRoleAssignments(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for role assignments in case {}", (Object)caseId);
            CaseRoleAssignmentList responseObject = this.caseManagementServiceBase.getRoleAssignment(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @PUT
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/xml", "application/json"})
    public Response addRoleAssignment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseRoleName") String roleName, @QueryParam(value="user") String user, @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to assign  user {}, group {} for role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.assignToRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @DELETE
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeRoleAssignment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseRoleName") String roleName, @QueryParam(value="user") String user, @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove user {}, group {} from role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.removeFromRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="instances/{caseId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceComments(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for comments in case {}", (Object)caseId);
            CaseCommentList responseObject = this.caseManagementServiceBase.getComments(containerId, caseId, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @POST
    @Path(value="instances/{caseId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response addComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @QueryParam(value="author") String author, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add comment to case {}", (Object)caseId);
            this.caseManagementServiceBase.addCommentToCase(containerId, caseId, author, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @PUT
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response updateComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseCommentId") String commentId, @QueryParam(value="author") String author, String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to update comment {} in case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.updateCommentInCase(containerId, caseId, commentId, author, payload, type);
                logger.debug("Returning CREATED response");
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @DELETE
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseId") String caseId, @PathParam(value="caseCommentId") String commentId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove comment {} from case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.removeCommentFromCase(containerId, caseId, commentId);
                logger.debug("Returning NO_CONTENT response");
                return RestUtils.noContent((Variant)v, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @GET
    @Path(value="instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstancesByContainer(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances in container {} with status {}", (Object)containerId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByContainer(containerId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="{caseDefId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstancesByDefinition(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseDefId") String caseDefId, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances with case definition id {} with status {}", (Object)caseDefId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByDefinition(containerId, caseDefId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseDefinitionsByContainer(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definitions in container {}", (Object)containerId);
            CaseDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinitionsByContainer(containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @GET
    @Path(value="definitions/{caseDefId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseDefinitionsByDefinition(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="caseDefId") String caseDefId) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definition with id {} in container {}", (Object)caseDefId, (Object)containerId);
            try {
                CaseDefinition responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinition(containerId, caseDefId);
                logger.debug("Returning OK response with content '{}'", (Object)responseObject);
                return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
            }
            catch (IllegalStateException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case definition \"{0}\" in container \"{1}\"", caseDefId, containerId), (Variant)v, (Header[])customHeaders);
            }
        });
    }
}

