/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.casemgmt.api.CaseCommentNotFoundException;
import org.jbpm.casemgmt.api.CaseDefinitionNotFoundException;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseCommentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseRoleAssignmentList;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.casemgmt.CaseManagementServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Case instances :: Case Management")
@Path(value="server/containers/{id}/cases")
public class CaseResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseResource.class);
    private CaseManagementServiceBase caseManagementServiceBase;

    public CaseResource() {
    }

    public CaseResource(CaseManagementServiceBase caseManagementServiceBase, CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
        this.caseManagementServiceBase = caseManagementServiceBase;
    }

    @ApiOperation(value="Starts new case instance of given case definition within given container with optional initial CaseFile (that provides variables and case role assignment)", response=String.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case definition or Container Id not found")})
    @POST
    @Path(value="{caseDefId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response startCase(@Context HttpHeaders headers, @ApiParam(value="container id where the case definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="case definition id that new instance should be created from", required=true) @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="optional CaseFile with variables and/or case role assignments", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            try {
                String response = this.caseManagementServiceBase.startCase(containerId, caseDefId, payload, type);
                logger.debug("Returning CREATED response for start case with content '{}'", (Object)response);
                return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
            }
            catch (CaseDefinitionNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case definition \"{0}\" in container \"{1}\"", caseDefId, containerId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Retrieves active case instance by given identifier (case id) with optionally loading data, roles, milestones and stages", response=CaseInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData, @ApiParam(value="optional flag to load roles when loading case instance", required=false) @QueryParam(value="withRoles") @DefaultValue(value="false") boolean withRoles, @ApiParam(value="optional flag to load milestones when loading case instance", required=false) @QueryParam(value="withMilestones") @DefaultValue(value="false") boolean withMilestones, @ApiParam(value="optional flag to load stages when loading case instance", required=false) @QueryParam(value="withStages") @DefaultValue(value="false") boolean withStages) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            String response = this.caseManagementServiceBase.getCaseInstance(containerId, caseId, withData, withRoles, withMilestones, withStages, type);
            logger.debug("Returning OK response for get case instance with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Cancels case instance with given identifier (case id) and has optional flag to permanently destroy the case instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="allows to destroy (permanently) case instance as part of the cancel operation, defaults to false", required=false) @QueryParam(value="destroy") @DefaultValue(value="false") boolean destroy) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.cancelCaseInstance(containerId, caseId, destroy);
            logger.debug("Returning NO CONTENT response after cancelling a case with id {}", (Object)caseId);
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Closes case instance with given identifier (case id) optionally with comment", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response closeCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional comment when closing a case instance as String", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.closeCaseInstance(containerId, caseId, payload, type);
            logger.debug("Returning NO CONTENT response after closing a case with id {}", (Object)caseId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Reopens case instance with given identifier (case id) by initiating given case definition", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="{caseDefId}/instances/{caseId}")
    @Produces(value={"application/xml", "application/json"})
    public Response reopenCase(@Context HttpHeaders headers, @ApiParam(value="container id where the case definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="case definition id that new instance should be created from", required=true) @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional CaseFile with variables and/or case role assignments", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.reopenCase(caseId, containerId, caseDefId, payload, type);
            logger.debug("Returning CREATED response for reopen case {}", (Object)caseId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves case instance data as map where key is the name of data item and value is actual instance of the data item from case file", response=Map.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional name(s) of the data items to retrieve", required=false) @QueryParam(value="name") List<String> names) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileData(containerId, caseId, names, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves case instance data by data item name", response=Object.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceDataByName(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="name of the data item within case file to retrieve", required=true) @PathParam(value="dataId") String caseDataName) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileDataByName(containerId, caseId, caseDataName, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Puts new data (map of variables) into case instance's case file", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response putCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional role name(s) that given data should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="map of data to be placed in case file as Map", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileData(containerId, caseId, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Puts new data (single data identified by name) into case instance's case file", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Produces(value={"application/xml", "application/json"})
    public Response putCaseInstanceDataByName(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="name of the data item to be added to case file", required=true) @PathParam(value="dataId") String caseDataName, @ApiParam(value="optional role name(s) that given data should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="data to be placed in case file, any type can be provided", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileDataByName(containerId, caseId, caseDataName, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Removes data items identified by name(s) from case instance's case file", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="one or more names of the data items to be removed from case file", required=true) @QueryParam(value="dataId") List<String> variableNames) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            if (variableNames == null || variableNames.isEmpty()) {
                return RestUtils.notFound((String)"Variable names to remove from case file not provided", (Variant)v, (Header[])customHeaders);
            }
            logger.debug("About to remove case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.removeCaseFileDataByName(containerId, caseId, variableNames);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds dynamic task (user or service depending on the payload) to case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/tasks")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="data for dynamic task (it represents task specification that drives the selection of the type of task)", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task to case {}", (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, null, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds dynamic task (user or service depending on the payload) to given stage within case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where dynamic task should be added", required=true) @PathParam(value="caseStageId") String stageId, @ApiParam(value="data for dynamic task (it represents task specification that drives the selection of the type of task)", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, stageId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds dynamic subprocess identified by process id to case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="process id of the subprocess to be added", required=true) @PathParam(value="pId") String processId, @ApiParam(value="data for dynamic subprocess", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, processId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess {} in case {}", (Object)processId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, null, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds dynamic subprocess identified by process id to stage within case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where dynamic subprocess should be added", required=true) @PathParam(value="caseStageId") String stageId, @ApiParam(value="process id of the subprocess to be added", required=true) @PathParam(value="pId") String processId, @ApiParam(value="data for dynamic subprocess", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, processId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, stageId, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Triggers ad hoc fragment in stage within case instance with optional data", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks/{nodeName}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerAdHocNodeInStage(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where adhoc fragment should be triggered", required=true) @PathParam(value="caseStageId") String stageId, @ApiParam(value="name of the adhoc fragment to be triggered", required=true) @PathParam(value="nodeName") String adHocName, @ApiParam(value="optional data to be given when triggering adhoc fragment", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in stage {} and in case {}", new Object[]{adHocName, stageId, caseId});
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, stageId, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Triggers ad hoc fragment in case instance with optional data", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/tasks/{nodeName}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerAdHocNode(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="name of the adhoc fragment to be triggered", required=true) @PathParam(value="nodeName") String adHocName, @ApiParam(value="optional data to be given when triggering adhoc fragment", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in case {}", (Object)adHocName, (Object)caseId);
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, null, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves milestones from case instance", response=CaseMilestoneList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/milestones")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceMilestones(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which milestones to load - achieved only or actives ones too, defaults to true", required=false) @QueryParam(value="achievedOnly") @DefaultValue(value="true") boolean achievedOnly, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for milestones in case {} achieved only = {}", (Object)caseId, (Object)achievedOnly);
            CaseMilestoneList responseObject = this.caseManagementRuntimeDataServiceBase.getMilestones(containerId, caseId, achievedOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves stages from case instance", response=CaseStageList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/stages")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceStages(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which stages to load - active only or completed ones too, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for stages in case {} active only = {}", (Object)caseId, (Object)activeOnly);
            CaseStageList responseObject = this.caseManagementRuntimeDataServiceBase.getStages(containerId, caseId, activeOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves adhoc fragments from case instance", response=CaseAdHocFragmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/adhocfragments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceAdHocFragments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for adhoc fragments in case {}", (Object)caseId);
            CaseAdHocFragmentList responseObject = this.caseManagementRuntimeDataServiceBase.getAdHocFragments(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves process instances that compose complete case instance", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/processes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            ArrayList<Integer> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<Integer>();
                actualStatus.add(1);
            }
            logger.debug("About to look for process instances in case {} with status {}", (Object)caseId, actualStatus);
            ProcessInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessInstancesForCase(containerId, caseId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves node instances from case instance", response=NodeInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/nodes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceActiveNodes(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which node instances to load - active or completed, defaults to false loading only active ones", required=false) @QueryParam(value="completed") @DefaultValue(value="false") Boolean completed, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for active nodes in case {}", (Object)caseId);
            NodeInstanceList responseObject = null;
            responseObject = completed != false ? this.caseManagementRuntimeDataServiceBase.getCompletedNodes(containerId, caseId, page, pageSize) : this.caseManagementRuntimeDataServiceBase.getActiveNodes(containerId, caseId, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves role assignments from case instance", response=CaseRoleAssignmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/roles")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceRoleAssignments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for role assignments in case {}", (Object)caseId);
            CaseRoleAssignmentList responseObject = this.caseManagementServiceBase.getRoleAssignment(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds new role assignment for given case, it can be either user or group based assignment", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/xml", "application/json"})
    public Response addRoleAssignment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="name of the case role the assignment should be set", required=true) @PathParam(value="caseRoleName") String roleName, @ApiParam(value="user to be aded to case role for given case instance", required=true) @QueryParam(value="user") String user, @ApiParam(value="group to be aded to case role for given case instance", required=true) @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to assign  user {}, group {} for role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.assignToRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Removes role assignment from user or group for given case instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeRoleAssignment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="name of the case role the assignment should be removed", required=true) @PathParam(value="caseRoleName") String roleName, @ApiParam(value="user to be removed from case role for given case instance", required=true) @QueryParam(value="user") String user, @ApiParam(value="group to be removed from case role for given case instance", required=true) @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove user {}, group {} from role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.removeFromRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves comments from case instance", response=CaseCommentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @GET
    @Path(value="instances/{caseId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstanceComments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for comments in case {}", (Object)caseId);
            CaseCommentList responseObject = this.caseManagementServiceBase.getComments(containerId, caseId, sort, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds new comment to given case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response addComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="author") String author, @ApiParam(value="optional role name(s) that given comment should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="actual content of the comment to be added as String", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add comment to case {}", (Object)caseId);
            String commentId = this.caseManagementServiceBase.addCommentToCase(containerId, caseId, author, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)commentId, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Updates comment within case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response updateComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the comment to be updated", required=true) @PathParam(value="caseCommentId") String commentId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="author") String author, @ApiParam(value="optional role name(s) that given comment should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="actual content of the comment to be updated to as String", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to update comment {} in case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.updateCommentInCase(containerId, caseId, commentId, author, restrictions, payload, type);
                logger.debug("Returning CREATED response");
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Removes given comment from case instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the comment to be removed", required=true) @PathParam(value="caseCommentId") String commentId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove comment {} from case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.removeCommentFromCase(containerId, caseId, commentId);
                logger.debug("Returning NO_CONTENT response");
                return RestUtils.noContent((Variant)v, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Retrieves case instances for given container only, allows to filter by case instance status and applies pagination", response=CaseInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstancesByContainer(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case instances", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances in container {} with status {}", (Object)containerId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByContainer(containerId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves case instances for given case definition only, allows to filter by case instance status and applies pagination", response=CaseInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="{caseDefId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstancesByDefinition(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case instances", required=true) @PathParam(value="id") String containerId, @ApiParam(value="case definition id that should be used to filter case instances", required=true) @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances with case definition id {} with status {}", (Object)caseDefId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByDefinition(containerId, caseDefId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves case definition for given container only, applies pagination", response=CaseDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseDefinitionsByContainer(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case definitions", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definitions in container {}", (Object)containerId);
            CaseDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinitionsByContainer(containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Retrieves case definition for given container and case definition id", response=CaseDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="definitions/{caseDefId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseDefinitionsByDefinition(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case definitions", required=true) @PathParam(value="id") String containerId, @ApiParam(value="case definition id that should be loaded", required=true) @PathParam(value="caseDefId") String caseDefId) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definition with id {} in container {}", (Object)caseDefId, (Object)containerId);
            try {
                CaseDefinition responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinition(containerId, caseDefId);
                logger.debug("Returning OK response with content '{}'", (Object)responseObject);
                return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
            }
            catch (IllegalStateException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case definition \"{0}\" in container \"{1}\"", caseDefId, containerId), (Variant)v, (Header[])customHeaders);
            }
        });
    }
}

