/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMigrationReportInstance;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseAdminServiceBase;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Administration of cases :: Case Management")
@Path(value="server/admin")
public class CaseAdminResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseAdminResource.class);
    private CaseAdminServiceBase caseAdminServiceBase;

    public CaseAdminResource() {
    }

    public CaseAdminResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, CaseAdminServiceBase caseAdminServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
        this.caseAdminServiceBase = caseAdminServiceBase;
    }

    @ApiOperation(value="Retrieves case instances without authentication checks and applies pagination", response=CaseInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="cases/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstances(@Context HttpHeaders headers, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseInstanceList responseObject = null;
            logger.debug("About to look for case instances with status {}", (Object)status);
            responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstances(status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Migrates case instance to new container and case definition with required process mapping to migrate all process instances belonging to a case instance with optional node mapping", response=CaseMigrationReportInstance.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance or Container Id not found")})
    @PUT
    @Path(value="containers/{id}/cases/instances/{caseId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response migrateCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of case instance to be migrated", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="container id that new case definition should be migrated to to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process and node mapping - unique ids of old definition to new definition given as Map of Maps - ProcessMapping should provide map of process definitions (mandatory), NodeMapping should provide map of node mappings (optional)", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"NodeMapping\" : { },\n  \"ProcessMapping\" : {\n    \"insurance-claims.CarInsuranceClaimCase\" : \"insurance-claims.CarInsuranceClaimCase2\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>ProcessMapping</key>\n            <value xsi:type=\"jaxbMap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <entries>\n                    <entry>\n                        <key>insurance-claims.CarInsuranceClaimCase</key>\n                        <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">insurance-claims.CarInsuranceClaimCase2</value>\n                    </entry>\n                </entries>\n            </value>\n        </entry>\n        <entry>\n            <key>NodeMapping</key>\n            <value xsi:type=\"jaxbMap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <entries/>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseMigrationReportInstance responseObject = this.caseAdminServiceBase.migrateCaseInstance(containerId, caseId, targetContainerId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }
}

