/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseFileDataItemList;
import org.kie.server.api.model.cases.CaseInstanceCustomVarsList;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseUserTaskWithVariablesList;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Case queries")
@Path(value="server/queries/cases")
public class CaseQueryResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseQueryResource.class);

    public CaseQueryResource() {
    }

    public CaseQueryResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
    }

    @ApiOperation(value="Returns cases instances with authentication checks.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"case-started-at\": 1540474204152,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    },\n    {\n      \"case-id\": \"IT-0000000011\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT6\",\n      \"case-started-at\": 1540496734746,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstances(@Context HttpHeaders headers, @ApiParam(value="data item name that case instances will be filtered by", required=false) @QueryParam(value="dataItemName") String dataItemName, @ApiParam(value="data item value that case instances will be filtered by", required=false) @QueryParam(value="dataItemValue") String dataItemValue, @ApiParam(value="case instance owner that case instances will be filtered by", required=false) @QueryParam(value="owner") String owner, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseInstanceList responseObject = null;
            if (dataItemName != null && !dataItemName.isEmpty() && dataItemValue != null && !dataItemValue.isEmpty()) {
                logger.debug("About to look for case instances by data item name {} and value {} with status {}", new Object[]{dataItemName, dataItemValue, status});
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByCaseFileData(dataItemName, dataItemValue, status, page, pageSize, sort, sortOrder, withData);
            } else if (dataItemName != null && !dataItemName.isEmpty()) {
                logger.debug("About to look for case instances by data item name {} with status {}", (Object)dataItemName, (Object)status);
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByCaseFileData(dataItemName, null, status, page, pageSize, sort, sortOrder, withData);
            } else if (owner != null && !owner.isEmpty()) {
                logger.debug("About to look for case instances owned by {} with status {}", (Object)owner, (Object)status);
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesOwnedBy(owner, status, page, pageSize, sort, sortOrder, withData);
            } else {
                logger.debug("About to look for case instances with status {}", (Object)status);
                responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesAnyRole(status, page, pageSize, sort, sortOrder, withData);
            }
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns cases instances that involve the querying user in a specified role.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"case-started-at\": 1540474204152,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    },\n    {\n      \"case-id\": \"IT-0000000011\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT6\",\n      \"case-started-at\": 1540496734746,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{caseRoleName}/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstancesByRole(@Context HttpHeaders headers, @ApiParam(value="case role that instances should be found for", required=true, example="owner") @PathParam(value="caseRoleName") String roleName, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instances with status {}", (Object)status);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByRole(roleName, status, page, pageSize, sort, sortOrder, withData);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns a specified case definition from all KIE containers.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successful response", response=CaseDefinitionList.class, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"definitions\": [\n    {\n      \"name\": \"Order for IT hardware\",\n      \"id\": \"itorders.orderhardware\",\n      \"version\": \"1.0\",\n      \"case-id-prefix\": \"IT\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT2\",\n      \"adhoc-fragments\": [\n        {\n          \"name\": \"Prepare hardware spec\",\n          \"type\": \"HumanTaskNode\"\n        },\n        {\n          \"name\": \"Milestone 1: Order placed\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 2: Order shipped\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 3: Delivered to customer\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Hardware spec ready\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Manager decision\",\n          \"type\": \"MilestoneNode\"\n        }\n      ],\n      \"roles\": {\n        \"owner\": 1,\n        \"manager\": 1,\n        \"supplier\": 2\n      },\n      \"milestones\": [\n        {\n          \"milestone-name\": \"Milestone 1: Order placed\",\n          \"milestone-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 2: Order shipped\",\n          \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 3: Delivered to customer\",\n          \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Hardware spec ready\",\n          \"milestone-id\": \"_483CF785-96DD-40C1-9148-4CFAFAE5778A\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Manager decision\",\n          \"milestone-id\": \"_79953D58-25DB-4FD6-94A0-DFC6EA2D0339\",\n          \"milestone-mandatory\": false\n        }\n      ],\n      \"stages\": []\n    },\n    {\n      \"name\": \"Order for IT hardware\",\n      \"id\": \"itorders.orderhardware\",\n      \"version\": \"1.0\",\n      \"case-id-prefix\": \"IT\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT3\",\n      \"adhoc-fragments\": [\n        {\n          \"name\": \"Prepare hardware spec\",\n          \"type\": \"HumanTaskNode\"\n        },\n        {\n          \"name\": \"Milestone 1: Order placed\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 2: Order shipped\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 3: Delivered to customer\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Hardware spec ready\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Manager decision\",\n          \"type\": \"MilestoneNode\"\n        }\n      ],\n      \"roles\": {\n        \"owner\": 1,\n        \"manager\": 1,\n        \"supplier\": 2\n      },\n      \"milestones\": [\n        {\n          \"milestone-name\": \"Milestone 1: Order placed\",\n          \"milestone-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 2: Order shipped\",\n          \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 3: Delivered to customer\",\n          \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Hardware spec ready\",\n          \"milestone-id\": \"_483CF785-96DD-40C1-9148-4CFAFAE5778A\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Manager decision\",\n          \"milestone-id\": \"_79953D58-25DB-4FD6-94A0-DFC6EA2D0339\",\n          \"milestone-mandatory\": false\n        }\n      ],\n      \"stages\": []\n    }\n  ]\n}")}))})
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseDefinitions(@Context HttpHeaders headers, @ApiParam(value="case definition id or name that case definitions will be filtered by", required=true) @QueryParam(value="filter") String filter, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definitions with filter {}", (Object)filter);
            CaseDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinitions(filter, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns a specified process associated with case definitions from all KIE containers.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ProcessDefinitionList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessDefinitions(@Context HttpHeaders headers, @ApiParam(value="process definition id or name that process definitions will be filtered by", required=true) @QueryParam(value="filter") String filter, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for process definitions with filter {}", (Object)filter);
            ProcessDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessDefinitions(filter, null, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns processes associated with case definitions in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ProcessDefinitionList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{containerId}/processes")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessDefinitionsByContainer(@Context HttpHeaders headers, @ApiParam(value="container id that process definitions should be filtered by", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for process definitions with container id {}", (Object)containerId);
            ProcessDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessDefinitions(null, containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns tasks for potential owners in a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=TaskSummaryList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/tasks/instances/pot-owners")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceTasksAsPotentialOwner(@Context HttpHeaders headers, @ApiParam(value="case instance identifier that tasks should belong to", required=true, example="CASE-00000000011") @PathParam(value="caseId") String caseId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String user, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to potential owner {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasks(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns tasks for business administrators in a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=TaskSummaryList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/tasks/instances/admins")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceTasksAsAdmin(@Context HttpHeaders headers, @ApiParam(value="case instance identifier that tasks should belong to", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String user, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to business admin {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasksAsBusinessAdmin(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns tasks for stakeholders in a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=TaskSummaryList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/tasks/instances/stakeholders")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceTasksAsStakeholder(@Context HttpHeaders headers, @ApiParam(value="case instance identifier that tasks should belong to", required=true, example="CASE-0000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String user, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            logger.debug("About to look for case instance {} tasks with status {} assigned to stakeholder {}", new Object[]{caseId, status, user});
            TaskSummaryList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseTasksAsStakeholder(caseId, user, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns case file data items for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseFileDataItemList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"name\": \"hwSpecNew\",\n      \"value\": \"New content for hardware specification.\",\n      \"type\": \"java.lang.String\",\n      \"last-modified-by\": \"baAdmin\",\n      \"last-modified\": 1540502077279\n    },\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"name\": \"milestone-mandatory\",\n      \"value\": \"false\",\n      \"type\": \"java.lang.Boolean\",\n      \"last-modified-by\": \"baAdmin\",\n      \"last-modified\": 1540499389943\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceDataItems(@Context HttpHeaders headers, @ApiParam(value="case instance identifier that data items should belong to", required=true, example="CASE-0000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optionally filter by data item names", required=false) @QueryParam(value="name") List<String> names, @ApiParam(value="optionally filter by data item types", required=false) @QueryParam(value="type") List<String> types, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, "", caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data items of case {}", (Object)caseId);
            CaseFileDataItemList response = this.caseManagementRuntimeDataServiceBase.getCaseInstanceDataItems(caseId, names, types, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createCorrectVariant((Object)response, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Queries cases by variables and tasks", response=CaseInstanceCustomVarsList.class)
    @POST
    @Path(value="variables/cases")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT, KieServerEndpoint.EndpointType.HISTORY})
    public Response queryCaseByVariables(@Context HttpHeaders headers, String payload, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String type = RestUtils.getContentType((HttpHeaders)headers);
            CaseInstanceCustomVarsList processVariableSummaryList = this.caseManagementRuntimeDataServiceBase.queryCasesByVariables(payload, type, new QueryContext(Integer.valueOf(page * pageSize), pageSize));
            logger.debug("Returning result of case instance search: {}", (Object)processVariableSummaryList);
            return RestUtils.createCorrectVariant((Object)processVariableSummaryList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Queries cases tasks by variables", response=CaseUserTaskWithVariablesList.class)
    @POST
    @Path(value="variables/cases/tasks")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT, KieServerEndpoint.EndpointType.HISTORY})
    public Response queryCaseUserTasksByVariables(@Context HttpHeaders headers, String payload, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String type = RestUtils.getContentType((HttpHeaders)headers);
            CaseUserTaskWithVariablesList taskVariableSummaryList = this.caseManagementRuntimeDataServiceBase.queryUserTasksByVariables(payload, type, new QueryContext(Integer.valueOf(page * pageSize), pageSize));
            logger.debug("Returning result of case instance user task search: {}", (Object)taskVariableSummaryList);
            return RestUtils.createCorrectVariant((Object)taskVariableSummaryList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

