/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.casemgmt.api.CaseCommentNotFoundException;
import org.jbpm.casemgmt.api.CaseDefinitionNotFoundException;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseCommentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseRoleAssignmentList;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.casemgmt.CaseManagementServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Case instances")
@Path(value="server/containers/{containerId}/cases")
public class CaseResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseResource.class);
    private CaseManagementServiceBase caseManagementServiceBase;

    public CaseResource() {
    }

    public CaseResource(CaseManagementServiceBase caseManagementServiceBase, CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
        this.caseManagementServiceBase = caseManagementServiceBase;
    }

    @ApiOperation(value="Starts a new case instance for a specified case definition.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case definition or Container Id not found"), @ApiResponse(code=201, response=String.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="\"CASE-0000000012\"")}))})
    @POST
    @Path(value="{caseDefId}/instances")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response startCase(@Context HttpHeaders headers, @ApiParam(value="container id where the case definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="case definition id that new instance should be created from", required=true, example="CASE-0000000001") @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="optional CaseFile with variables and/or case role assignments", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"case-data\" : {\n    \"car\" : \"ford\"\n  },\n  \"case-user-assignments\" : {\n    \"insured\" : \"yoda\",\n    \"insuranceRepresentative\" : \"john\"\n  },\n  \"case-group-assignments\" : { },\n  \"case-data-restrictions\" : { }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<case-file>\n    <data>\n        <entry>\n            <key>car</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">ford</value>\n        </entry>\n    </data>\n    <userAssignments>\n        <entry>\n            <key>insured</key>\n            <value>yoda</value>\n        </entry>\n        <entry>\n            <key>insuranceRepresentative</key>\n            <value>john</value>\n        </entry>\n    </userAssignments>\n    <groupAssignments/>\n    <accessRestrictions/>\n</case-file>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            try {
                String response = this.caseManagementServiceBase.startCase(containerId, caseDefId, payload, type);
                logger.debug("Returning CREATED response for start case with content '{}'", (Object)response);
                return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
            }
            catch (CaseDefinitionNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case definition \"{0}\" in container \"{1}\"", caseDefId, containerId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Returns information about a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"case-id\": \"IT-0000000006\",\n  \"case-description\": \"Order for IT hardware\",\n  \"case-owner\": \"baAdmin\",\n  \"case-status\": 1,\n  \"case-definition-id\": \"itorders.orderhardware\",\n  \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n  \"case-started-at\": 1540474204152,\n  \"case-completed-at\": null,\n  \"case-completion-msg\": \"\",\n  \"case-sla-compliance\": 0,\n  \"case-sla-due-date\": null,\n  \"case-file\": {\n    \"case-data\": {},\n    \"case-user-assignments\": {},\n    \"case-group-assignments\": {},\n    \"case-data-restrictions\": {}\n  },\n  \"case-milestones\": null,\n  \"case-stages\": null,\n  \"case-roles\": [\n    {\n      \"name\": \"owner\",\n      \"users\": [\n        \"baAdmin\"\n      ],\n      \"groups\": []\n    },\n    {\n      \"name\": \"manager\",\n      \"users\": [\n        \"baAdmin\"\n      ],\n      \"groups\": []\n    },\n    {\n      \"name\": \"supplier\",\n      \"users\": [],\n      \"groups\": [\n        \"IT\"\n      ]\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData, @ApiParam(value="optional flag to load roles when loading case instance", required=false) @QueryParam(value="withRoles") @DefaultValue(value="false") boolean withRoles, @ApiParam(value="optional flag to load milestones when loading case instance", required=false) @QueryParam(value="withMilestones") @DefaultValue(value="false") boolean withMilestones, @ApiParam(value="optional flag to load stages when loading case instance", required=false) @QueryParam(value="withStages") @DefaultValue(value="false") boolean withStages) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            String response = this.caseManagementServiceBase.getCaseInstance(containerId, caseId, withData, withRoles, withMilestones, withStages, type);
            logger.debug("Returning OK response for get case instance with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Aborts or permanently destroys a specified case instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="allows to destroy (permanently) case instance as part of the cancel operation, defaults to false", required=false) @QueryParam(value="destroy") @DefaultValue(value="false") boolean destroy) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.cancelCaseInstance(containerId, caseId, destroy);
            logger.debug("Returning NO CONTENT response after cancelling a case with id {}", (Object)caseId);
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Closes a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}")
    @Produces(value={"application/json", "application/xml"})
    public Response closeCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional comment when closing a case instance as String", required=false) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.closeCaseInstance(containerId, caseId, payload, type);
            logger.debug("Returning NO CONTENT response after closing a case with id {}", (Object)caseId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Reopens a closed case instance for a specified case definition.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="{caseDefId}/instances/{caseId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response reopenCase(@Context HttpHeaders headers, @ApiParam(value="container id where the case definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="case definition id that new instance should be created from", required=true, example="evaluation") @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="identifier of the case instance", required=true) @PathParam(value="caseId") String caseId, @ApiParam(value="optional CaseFile with variables and/or case role assignments", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"case-data\" : {\n    \"car\" : \"ford\"\n  },\n  \"case-user-assignments\" : {\n    \"insured\" : \"yoda\",\n    \"insuranceRepresentative\" : \"john\"\n  },\n  \"case-group-assignments\" : { },\n  \"case-data-restrictions\" : { }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<case-file>\n    <data>\n        <entry>\n            <key>car</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">ford</value>\n        </entry>\n    </data>\n    <userAssignments>\n        <entry>\n            <key>insured</key>\n            <value>yoda</value>\n        </entry>\n        <entry>\n            <key>insuranceRepresentative</key>\n            <value>john</value>\n        </entry>\n    </userAssignments>\n    <groupAssignments/>\n    <accessRestrictions/>\n</case-file>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            this.caseManagementServiceBase.reopenCase(caseId, containerId, caseDefId, payload, type);
            logger.debug("Returning CREATED response for reopen case {}", (Object)caseId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns data from the case files of a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=Map.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}")}))})
    @GET
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional name(s) of the data items to retrieve", required=false) @QueryParam(value="name") List<String> names) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileData(containerId, caseId, names, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns the value of a specified case file data item in a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=Object.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}")}))})
    @GET
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceDataByName(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="name of the data item within case file to retrieve", required=true) @PathParam(value="dataId") String caseDataName) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to load case file data of case {}", (Object)caseId);
            String response = this.caseManagementServiceBase.getCaseFileDataByName(containerId, caseId, caseDataName, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds data as case files in a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/caseFile")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response putCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional role name(s) that given data should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="map of data to be placed in case file as Map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileData(containerId, caseId, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds a single data item as a case file in a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/caseFile/{dataId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response putCaseInstanceDataByName(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="name of the data item to be added to case file", required=true) @PathParam(value="dataId") String caseDataName, @ApiParam(value="optional role name(s) that given data should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="data to be placed in case file, any type can be provided", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to put case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.putCaseFileDataByName(containerId, caseId, caseDataName, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Deletes one or more specified case file data items from a specified case instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/caseFile")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteCaseInstanceData(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="one or more names of the data items to be removed from case file", required=true) @QueryParam(value="dataId") List<String> variableNames) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            if (variableNames == null || variableNames.isEmpty()) {
                return RestUtils.notFound((String)"Variable names to remove from case file not provided", (Variant)v, (Header[])customHeaders);
            }
            logger.debug("About to remove case file data of case {}", (Object)caseId);
            this.caseManagementServiceBase.removeCaseFileDataByName(containerId, caseId, variableNames);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds a dynamic user task or service task to the specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/tasks")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="data for dynamic task (it represents task specification that drives the selection of the type of task)", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task to case {}", (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, null, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds a dynamic user task or service task to the specified stage in a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addDynamicTaskToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where dynamic task should be added", required=true, example="stageOne") @PathParam(value="caseStageId") String stageId, @ApiParam(value="data for dynamic task (it represents task specification that drives the selection of the type of task)", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic task stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicTask(containerId, caseId, stageId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds a dynamic subprocess to a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/processes/{processId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="process id of the subprocess to be added", required=true, example="placeOrder") @PathParam(value="processId") String processId, @ApiParam(value="data for dynamic subprocess", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, processId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess {} in case {}", (Object)processId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, null, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds dynamic subprocess identified by process id to stage within case instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/stages/{caseStageId}/processes/{processId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addDynamicProcessToCase(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where dynamic subprocess should be added", required=true, example="stageOne") @PathParam(value="caseStageId") String stageId, @ApiParam(value="process id of the subprocess to be added", required=true) @PathParam(value="processId") String processId, @ApiParam(value="data for dynamic subprocess", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, processId, (v, type, customHeaders) -> {
            logger.debug("About to add dynamic subprocess stage {} in case {}", (Object)stageId, (Object)caseId);
            this.caseManagementServiceBase.addDynamicSubprocess(containerId, caseId, stageId, processId, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Triggers a specified ad hoc fragment in the specified stage of a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/stages/{caseStageId}/tasks/{nodeName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response triggerAdHocNodeInStage(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the stage within case instance where adhoc fragment should be triggered", required=true, example="stageOne") @PathParam(value="caseStageId") String stageId, @ApiParam(value="name of the adhoc fragment to be triggered", required=true) @PathParam(value="nodeName") String adHocName, @ApiParam(value="optional data to be given when triggering adhoc fragment", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in stage {} and in case {}", new Object[]{adHocName, stageId, caseId});
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, stageId, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Triggers a specified ad hoc fragment in a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/tasks/{nodeName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response triggerAdHocNode(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="name of the adhoc fragment to be triggered", required=true, example="sampleTask") @PathParam(value="nodeName") String adHocName, @ApiParam(value="optional data to be given when triggering adhoc fragment", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to trigger ad hoc task {} in case {}", (Object)adHocName, (Object)caseId);
            this.caseManagementServiceBase.triggerAdHocNode(containerId, caseId, null, adHocName, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns milestones for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseMilestoneList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"milestones\": [\n    {\n      \"milestone-name\": \"Milestone 1: Order placed\",\n      \"milestone-id\": \"1\",\n      \"milestone-achieved\": false,\n      \"milestone-achieved-at\": null,\n      \"milestone-status\": \"Available\"\n    },\n    {\n      \"milestone-name\": \"Hardware spec ready\",\n      \"milestone-id\": \"2\",\n      \"milestone-achieved\": false,\n      \"milestone-achieved-at\": null,\n      \"milestone-status\": \"Available\"\n    },\n    {\n      \"milestone-name\": \"Manager decision\",\n      \"milestone-id\": \"3\",\n      \"milestone-achieved\": false,\n      \"milestone-achieved-at\": null,\n      \"milestone-status\": \"Available\"\n    },\n    {\n      \"milestone-name\": \"Milestone 2: Order shipped\",\n      \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n      \"milestone-achieved\": false,\n      \"milestone-achieved-at\": null,\n      \"milestone-status\": \"Available\"\n    },\n    {\n      \"milestone-name\": \"Milestone 3: Delivered to customer\",\n      \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n      \"milestone-achieved\": false,\n      \"milestone-achieved-at\": null,\n      \"milestone-status\": \"Available\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/milestones")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceMilestones(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which milestones to load - achieved only or actives ones too, defaults to true", required=false) @QueryParam(value="achievedOnly") @DefaultValue(value="true") boolean achievedOnly, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for milestones in case {} achieved only = {}", (Object)caseId, (Object)achievedOnly);
            CaseMilestoneList responseObject = this.caseManagementRuntimeDataServiceBase.getMilestones(containerId, caseId, achievedOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns stages for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseStageList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"stages\": [\n    {\n      \"stage-name\": \"string\",\n      \"stage-id\": \"string\",\n      \"stage-status\": \"string\",\n      \"adhoc-fragments\": [\n        {\n          \"name\": \"string\",\n          \"type\": \"string\"\n        }\n      ],\n      \"active-nodes\": [\n        {\n          \"node-instance-id\": 0,\n          \"node-name\": \"string\",\n          \"process-instance-id\": 0,\n          \"work-item-id\": 0,\n          \"container-id\": \"string\",\n          \"start-date\": \"2018-10-25T18:34:44.456Z\",\n          \"node-id\": \"string\",\n          \"node-type\": \"string\",\n          \"node-connection\": \"string\",\n          \"node-completed\": true,\n          \"reference-id\": 0,\n          \"sla-compliance\": 0,\n          \"sla-due-date\": \"2018-10-25T18:34:44.456Z\"\n        }\n      ]\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/stages")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceStages(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which stages to load - active only or completed ones too, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for stages in case {} active only = {}", (Object)caseId, (Object)activeOnly);
            CaseStageList responseObject = this.caseManagementRuntimeDataServiceBase.getStages(containerId, caseId, activeOnly, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns ad hoc fragments for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseAdHocFragmentList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"fragments\": [\n    {\n      \"name\": \"Prepare hardware spec\",\n      \"type\": \"HumanTaskNode\"\n    },\n    {\n      \"name\": \"Milestone 1: Order placed\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Milestone 2: Order shipped\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Milestone 3: Delivered to customer\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Hardware spec ready\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Manager decision\",\n      \"type\": \"MilestoneNode\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/adhocfragments")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceAdHocFragments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for adhoc fragments in case {}", (Object)caseId);
            CaseAdHocFragmentList responseObject = this.caseManagementRuntimeDataServiceBase.getAdHocFragments(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns process instances in a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=ProcessInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 26,\n      \"process-id\": \"itorders.orderhardware\",\n      \"process-name\": \"Order for IT hardware\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1540474204152\n      },\n      \"process-instance-desc\": \"Order for IT hardware\",\n      \"correlation-key\": \"IT-0000000006\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 34,\n      \"process-id\": \"itorders-data.place-order\",\n      \"process-name\": \"place-order\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1540504523492\n      },\n      \"process-instance-desc\": \"Order IT-0000000006\",\n      \"correlation-key\": \"IT-0000000006:itorders-data.place-order:1540504523491\",\n      \"parent-instance-id\": 26,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/processes/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            ArrayList<Integer> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<Integer>();
                actualStatus.add(1);
            }
            logger.debug("About to look for process instances in case {} with status {}", (Object)caseId, actualStatus);
            ProcessInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getProcessInstancesForCase(containerId, caseId, actualStatus, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns node instances for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=NodeInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"node-instance\": [\n    {\n      \"node-instance-id\": 0,\n      \"node-name\": \"Prepare hardware spec\",\n      \"process-instance-id\": 26,\n      \"work-item-id\": 35,\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"start-date\": {\n        \"java.util.Date\": 1540474204152\n      },\n      \"node-id\": \"_BFA6002D-0917-42CE-81AD-2A15EC814684\",\n      \"node-type\": \"HumanTaskNode\",\n      \"node-connection\": null,\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    },\n    {\n      \"node-instance-id\": 1,\n      \"node-name\": \"Milestone 1: Order placed\",\n      \"process-instance-id\": 26,\n      \"work-item-id\": null,\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"start-date\": {\n        \"java.util.Date\": 1540474204156\n      },\n      \"node-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n      \"node-type\": \"MilestoneNode\",\n      \"node-connection\": null,\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    },\n    {\n      \"node-instance-id\": 1,\n      \"node-name\": \"Place order\",\n      \"process-instance-id\": 34,\n      \"work-item-id\": 46,\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"start-date\": {\n        \"java.util.Date\": 1540504523493\n      },\n      \"node-id\": \"_FCADC388-8A68-40E1-94A7-4F8A7D2B21C2\",\n      \"node-type\": \"HumanTaskNode\",\n      \"node-connection\": \"_384EFF84-BB14-4917-89C3-32DF4ACA1878\",\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/nodes/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceActiveNodes(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional flag that allows to control which node instances to load - active or completed, defaults to false loading only active ones", required=false) @QueryParam(value="completed") @DefaultValue(value="false") Boolean completed, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for active nodes in case {}", (Object)caseId);
            NodeInstanceList responseObject = null;
            responseObject = completed != false ? this.caseManagementRuntimeDataServiceBase.getCompletedNodes(containerId, caseId, page, pageSize) : this.caseManagementRuntimeDataServiceBase.getActiveNodes(containerId, caseId, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns role assignments for a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseRoleAssignmentList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"role-assignments\": [\n    {\n      \"name\": \"owner\",\n      \"users\": [\n        \"baAdmin\"\n      ],\n      \"groups\": []\n    },\n    {\n      \"name\": \"manager\",\n      \"users\": [\n        \"baAdmin\"\n      ],\n      \"groups\": []\n    },\n    {\n      \"name\": \"supplier\",\n      \"users\": [],\n      \"groups\": [\n        \"IT\"\n      ]\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/roles")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceRoleAssignments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for role assignments in case {}", (Object)caseId);
            CaseRoleAssignmentList responseObject = this.caseManagementServiceBase.getRoleAssignment(containerId, caseId);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Assigns a specified case role to a specified user and group for a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/json", "application/xml"})
    public Response addRoleAssignment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="name of the case role the assignment should be set", required=true, example="owner") @PathParam(value="caseRoleName") String roleName, @ApiParam(value="user to be aded to case role for given case instance", required=true) @QueryParam(value="user") String user, @ApiParam(value="group to be aded to case role for given case instance", required=true) @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to assign  user {}, group {} for role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.assignToRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Removes an assigned case role from a specified user and group for a specified case instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/roles/{caseRoleName}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeRoleAssignment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="name of the case role the assignment should be removed", required=true, example="owner") @PathParam(value="caseRoleName") String roleName, @ApiParam(value="user to be removed from case role for given case instance", required=true) @QueryParam(value="user") String user, @ApiParam(value="group to be removed from case role for given case instance", required=true) @QueryParam(value="group") String group) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove user {}, group {} from role {} in case {}", new Object[]{user, group, roleName, caseId});
            this.caseManagementServiceBase.removeFromRole(containerId, caseId, roleName, user, group);
            logger.debug("Returning NO_CONTENT response");
            return RestUtils.noContent((Variant)v, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns comments from a specified case instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found"), @ApiResponse(code=200, response=CaseCommentList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"comments\": [\n    {\n      \"id\": \"f15419b6-1967-479b-8509-066f579c59e1\",\n      \"author\": \"baAdmin\",\n      \"text\": \"Updated case with new ad hoc fragment.\",\n      \"added-at\": {\n        \"java.util.Date\": 1540494739762\n      },\n      \"restricted-to\": [\n        \"owner\"\n      ]\n    }\n      {\n        \"id\": \"2b072823-7448-4819-9560-01165bc7e805\",\n        \"author\": \"baAdmin\",\n        \"text\": \"Removed hardware preparation requirement.\",\n        \"added-at\": {\n          \"java.util.Date\": 1540494802456\n        },\n        \"restricted-to\": [\n          \"supplier\"\n        ]\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{caseId}/comments")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstanceComments(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to look for comments in case {}", (Object)caseId);
            CaseCommentList responseObject = this.caseManagementServiceBase.getComments(containerId, caseId, sort, page, pageSize);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Adds a comment to a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @POST
    @Path(value="instances/{caseId}/comments")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="author") String author, @ApiParam(value="optional role name(s) that given comment should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="actual content of the comment to be added as String", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to add comment to case {}", (Object)caseId);
            String commentId = this.caseManagementServiceBase.addCommentToCase(containerId, caseId, author, restrictions, payload, type);
            logger.debug("Returning CREATED response");
            return RestUtils.createResponse((Object)commentId, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Updates a specified comment in a specified case instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @PUT
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the comment to be updated", required=true, example="xxx-yyy-zzz") @PathParam(value="caseCommentId") String commentId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="author") String author, @ApiParam(value="optional role name(s) that given comment should be restricted to", required=false) @QueryParam(value="restrictedTo") List<String> restrictions, @ApiParam(value="actual content of the comment to be updated to as String", required=true) String payload) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to update comment {} in case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.updateCommentInCase(containerId, caseId, commentId, author, restrictions, payload, type);
                logger.debug("Returning CREATED response");
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Deletes a specified comment in a specified case instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance not found")})
    @DELETE
    @Path(value="instances/{caseId}/comments/{caseCommentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeComment(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the case instance", required=true, example="CASE-00000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="identifier of the comment to be removed", required=true, example="xxx-yyy-zzz") @PathParam(value="caseCommentId") String commentId) {
        return this.invokeCaseOperation(headers, containerId, caseId, (v, type, customHeaders) -> {
            logger.debug("About to remove comment {} from case {}", (Object)commentId, (Object)caseId);
            try {
                this.caseManagementServiceBase.removeCommentFromCase(containerId, caseId, commentId);
                logger.debug("Returning NO_CONTENT response");
                return RestUtils.noContent((Variant)v, (Header[])customHeaders);
            }
            catch (CaseCommentNotFoundException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case comment with id \"{0}\" in case \"{1}\"", commentId, caseId), (Variant)v, (Header[])customHeaders);
            }
        });
    }

    @ApiOperation(value="Returns case instances in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"case-started-at\": 1540474204152,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    },\n    {\n      \"case-id\": \"IT-0000000011\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT6\",\n      \"case-started-at\": 1540496734746,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstancesByContainer(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case instances", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances in container {} with status {}", (Object)containerId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByContainer(containerId, actualStatus, page, pageSize, sort, sortOrder, withData);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns case instances for a specified case definition.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"case-started-at\": 1540474204152,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    },\n    {\n      \"case-id\": \"IT-0000000011\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT6\",\n      \"case-started-at\": 1540496734746,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{caseDefId}/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstancesByDefinition(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case instances", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="case definition id that should be used to filter case instances", required=true, example="CASE-00000000001") @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            ArrayList<String> actualStatus = status;
            if (status == null || status.isEmpty()) {
                actualStatus = new ArrayList<String>();
                actualStatus.add(CaseStatus.OPEN.getName());
            }
            logger.debug("About to look for case instances with case definition id {} with status {}", (Object)caseDefId, actualStatus);
            CaseInstanceList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstancesByDefinition(containerId, caseDefId, actualStatus, page, pageSize, sort, sortOrder, withData);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns case definitions in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseDefinitionList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"definitions\": [\n    {\n      \"name\": \"Order for IT hardware\",\n      \"id\": \"itorders.orderhardware\",\n      \"version\": \"1.0\",\n      \"case-id-prefix\": \"IT\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT2\",\n      \"adhoc-fragments\": [\n        {\n          \"name\": \"Prepare hardware spec\",\n          \"type\": \"HumanTaskNode\"\n        },\n        {\n          \"name\": \"Milestone 1: Order placed\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 2: Order shipped\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 3: Delivered to customer\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Hardware spec ready\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Manager decision\",\n          \"type\": \"MilestoneNode\"\n        }\n      ],\n      \"roles\": {\n        \"owner\": 1,\n        \"manager\": 1,\n        \"supplier\": 2\n      },\n      \"milestones\": [\n        {\n          \"milestone-name\": \"Milestone 1: Order placed\",\n          \"milestone-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 2: Order shipped\",\n          \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 3: Delivered to customer\",\n          \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Hardware spec ready\",\n          \"milestone-id\": \"_483CF785-96DD-40C1-9148-4CFAFAE5778A\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Manager decision\",\n          \"milestone-id\": \"_79953D58-25DB-4FD6-94A0-DFC6EA2D0339\",\n          \"milestone-mandatory\": false\n        }\n      ],\n      \"stages\": []\n    },\n    {\n      \"name\": \"Order for IT hardware\",\n      \"id\": \"itorders.orderhardware\",\n      \"version\": \"1.0\",\n      \"case-id-prefix\": \"IT\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT3\",\n      \"adhoc-fragments\": [\n        {\n          \"name\": \"Prepare hardware spec\",\n          \"type\": \"HumanTaskNode\"\n        },\n        {\n          \"name\": \"Milestone 1: Order placed\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 2: Order shipped\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Milestone 3: Delivered to customer\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Hardware spec ready\",\n          \"type\": \"MilestoneNode\"\n        },\n        {\n          \"name\": \"Manager decision\",\n          \"type\": \"MilestoneNode\"\n        }\n      ],\n      \"roles\": {\n        \"owner\": 1,\n        \"manager\": 1,\n        \"supplier\": 2\n      },\n      \"milestones\": [\n        {\n          \"milestone-name\": \"Milestone 1: Order placed\",\n          \"milestone-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 2: Order shipped\",\n          \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Milestone 3: Delivered to customer\",\n          \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Hardware spec ready\",\n          \"milestone-id\": \"_483CF785-96DD-40C1-9148-4CFAFAE5778A\",\n          \"milestone-mandatory\": false\n        },\n        {\n          \"milestone-name\": \"Manager decision\",\n          \"milestone-id\": \"_79953D58-25DB-4FD6-94A0-DFC6EA2D0339\",\n          \"milestone-mandatory\": false\n        }\n      ],\n      \"stages\": []\n    }\n  ]\n}")}))})
    @GET
    @Path(value="definitions")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseDefinitionsByContainer(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case definitions", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definitions in container {}", (Object)containerId);
            CaseDefinitionList responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinitionsByContainer(containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Returns information about a specified case definition.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseDefinition.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"name\": \"Order for IT hardware\",\n  \"id\": \"itorders.orderhardware\",\n  \"version\": \"1.0\",\n  \"case-id-prefix\": \"IT\",\n  \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n  \"adhoc-fragments\": [\n    {\n      \"name\": \"Prepare hardware spec\",\n      \"type\": \"HumanTaskNode\"\n    },\n    {\n      \"name\": \"Milestone 1: Order placed\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Milestone 2: Order shipped\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Milestone 3: Delivered to customer\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Hardware spec ready\",\n      \"type\": \"MilestoneNode\"\n    },\n    {\n      \"name\": \"Manager decision\",\n      \"type\": \"MilestoneNode\"\n    }\n  ],\n  \"roles\": {\n    \"owner\": 1,\n    \"manager\": 1,\n    \"supplier\": 2\n  },\n  \"milestones\": [\n    {\n      \"milestone-name\": \"Milestone 1: Order placed\",\n      \"milestone-id\": \"_DCD97847-6E3C-4C5E-9EE3-221C04BE42ED\",\n      \"milestone-mandatory\": false\n    },\n    {\n      \"milestone-name\": \"Milestone 2: Order shipped\",\n      \"milestone-id\": \"_343B90CD-AA19-4894-B63C-3CE1906E6FD1\",\n      \"milestone-mandatory\": false\n    },\n    {\n      \"milestone-name\": \"Milestone 3: Delivered to customer\",\n      \"milestone-id\": \"_52AFA23F-C087-4519-B8F2-BABCC31D68A6\",\n      \"milestone-mandatory\": false\n    },\n    {\n      \"milestone-name\": \"Hardware spec ready\",\n      \"milestone-id\": \"_483CF785-96DD-40C1-9148-4CFAFAE5778A\",\n      \"milestone-mandatory\": false\n    },\n    {\n      \"milestone-name\": \"Manager decision\",\n      \"milestone-id\": \"_79953D58-25DB-4FD6-94A0-DFC6EA2D0339\",\n      \"milestone-mandatory\": false\n    }\n  ],\n  \"stages\": []\n}")}))})
    @GET
    @Path(value="definitions/{caseDefId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseDefinitionsByDefinition(@Context HttpHeaders headers, @ApiParam(value="container id that should be used to filter case definitions", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="case definition id that should be loaded", required=true, example="CASE-00000000001") @PathParam(value="caseDefId") String caseDefId) {
        return this.invokeCaseOperation(headers, containerId, null, (v, type, customHeaders) -> {
            logger.debug("About to look for case definition with id {} in container {}", (Object)caseDefId, (Object)containerId);
            try {
                CaseDefinition responseObject = this.caseManagementRuntimeDataServiceBase.getCaseDefinition(containerId, caseDefId);
                logger.debug("Returning OK response with content '{}'", (Object)responseObject);
                return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
            }
            catch (IllegalStateException e) {
                return RestUtils.notFound((String)MessageFormat.format("Could not find case definition \"{0}\" in container \"{1}\"", caseDefId, containerId), (Variant)v, (Header[])customHeaders);
            }
        });
    }
}

