/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Administration of cases :: Case Management")
@Path(value="server/admin/cases")
public class CaseAdminResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseAdminResource.class);

    public CaseAdminResource() {
    }

    public CaseAdminResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
    }

    @ApiOperation(value="Retrieves case instances without authntication checks and applies pagination", response=CaseInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getCaseInstances(@Context HttpHeaders headers, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseInstanceList responseObject = null;
            logger.debug("About to look for case instances with status {}", (Object)status);
            responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstances(status, page, pageSize, sort, sortOrder);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }
}

