/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.kie.server.remote.rest.common.marker.KieServerEndpointRequestFilter;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;

@ApplicationPath(value="/")
public class KieServerApplication
extends Application {
    private final Set<Object> instances = new CopyOnWriteArraySet<Object>(){
        private static final long serialVersionUID = 1763183096852523317L;
        {
            KieServerImpl server = KieServerLocator.getInstance();
            this.add(new KieServerRestImpl(server));
            List extensions = server.getServerExtensions();
            for (KieServerExtension extension : extensions) {
                this.addAll(extension.getAppComponents(SupportedTransports.REST));
            }
            if (Boolean.getBoolean("org.kie.server.rest.mode.readonly")) {
                this.add(new KieServerEndpointRequestFilter());
            }
        }
    };

    public Set<Class<?>> getClasses() {
        return Collections.emptySet();
    }

    public Set<Object> getSingletons() {
        return this.instances;
    }
}

