/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.swagger;

import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.Operation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.GET;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;

public class ReadOnlySwaggerDecoration
extends AbstractSwaggerExtension {
    public static final String SWAGGER_EXTENSION_READ_ONLY = "x-readonly";
    private final List<KieServerEndpoint.EndpointType> valid = Arrays.asList(KieServerEndpoint.EndpointType.ALWAYS, KieServerEndpoint.EndpointType.HISTORY);

    public void decorateOperation(Operation operation, Method method, Iterator<SwaggerExtension> chain) {
        if (method.isAnnotationPresent(GET.class)) {
            operation.setVendorExtension(SWAGGER_EXTENSION_READ_ONLY, (Object)Boolean.TRUE);
            if (chain.hasNext()) {
                chain.next().decorateOperation(operation, method, chain);
            }
            return;
        }
        KieServerEndpoint api = method.getAnnotation(KieServerEndpoint.class);
        if (api == null) {
            api = method.getDeclaringClass().getAnnotation(KieServerEndpoint.class);
        }
        if (api != null) {
            ArrayList<KieServerEndpoint.EndpointType> current = new ArrayList<KieServerEndpoint.EndpointType>(Arrays.asList(api.categories()));
            current.retainAll(this.valid);
            if (!current.isEmpty()) {
                operation.setVendorExtension(SWAGGER_EXTENSION_READ_ONLY, (Object)Boolean.TRUE);
            }
        }
        if (chain.hasNext()) {
            chain.next().decorateOperation(operation, method, chain);
        }
    }
}

