/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.swagger;

import io.swagger.config.FilterFactory;
import io.swagger.core.filter.AbstractSpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.model.ApiDescription;
import io.swagger.models.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.server.remote.rest.swagger.KieApiListingResource;
import org.kie.server.remote.rest.swagger.ReadOnlySwaggerDecoration;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.SupportedTransports;

public class SwaggerRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "Swagger";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        if (Boolean.getBoolean("org.kie.server.rest.mode.readonly")) {
            AbstractSpecFilter filter = new AbstractSpecFilter(){

                public boolean isOperationAllowed(Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                    return operation.getVendorExtensions().containsKey("x-readonly");
                }
            };
            FilterFactory.setFilter((SwaggerSpecFilter)filter);
            ArrayList<ReadOnlySwaggerDecoration> extensions = new ArrayList<ReadOnlySwaggerDecoration>(SwaggerExtensions.getExtensions());
            extensions.add(new ReadOnlySwaggerDecoration());
            SwaggerExtensions.setExtensions(extensions);
        }
        ArrayList<Object> components = new ArrayList<Object>(2);
        components.add((Object)new KieApiListingResource());
        components.add(new SwaggerSerializers());
        return components;
    }
}

