/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class GatedStreamSourceChannel
implements StreamSourceChannel {
    private final StreamSourceChannel delegate;
    private final ChannelListener.SimpleSetter<GatedStreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<GatedStreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();
    private int state;
    private static final int FLAG_GATE_OPEN = 1;
    private static final int FLAG_READS_RESUMED = 2;
    private static final int FLAG_CLOSE_REQUESTED = 4;
    private static final int FLAG_CLOSED = 8;

    public GatedStreamSourceChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
    }

    public void openGate() throws IOException {
        int val = this.state;
        if (Bits.allAreSet(val, 1)) {
            return;
        }
        this.state |= 1;
        if (Bits.allAreSet(val, 8)) {
            this.delegate.close();
        } else {
            if (Bits.allAreSet(val, 4)) {
                this.delegate.shutdownReads();
            }
            if (Bits.allAreSet(val, 2)) {
                this.delegate.wakeupReads();
            }
        }
    }

    public boolean isGateOpen() {
        return Bits.allAreSet(this.state, 1);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            return -1L;
        }
        if (Bits.anyAreClear(val, 1)) {
            return 0L;
        }
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            return -1L;
        }
        if (Bits.anyAreClear(val, 1)) {
            return 0L;
        }
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            return -1L;
        }
        if (Bits.anyAreClear(val, 1)) {
            return 0L;
        }
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            return -1L;
        }
        if (Bits.anyAreClear(val, 1)) {
            return 0L;
        }
        return this.delegate.read(dsts);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            return -1;
        }
        if (Bits.anyAreClear(val, 1)) {
            return 0;
        }
        return this.delegate.read(dst);
    }

    @Override
    public void suspendReads() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.suspendReads();
        } else {
            this.state &= 0xFFFFFFFD;
        }
    }

    @Override
    public void resumeReads() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.resumeReads();
        } else {
            this.state |= 2;
        }
    }

    @Override
    public boolean isReadResumed() {
        if (Bits.anyAreSet(this.state, 1)) {
            return this.delegate.isReadResumed();
        }
        return Bits.anyAreSet(this.state, 2);
    }

    @Override
    public void wakeupReads() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.resumeReads();
        } else {
            this.state |= 2;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelListeners.invokeChannelListener(GatedStreamSourceChannel.this, GatedStreamSourceChannel.this.readSetter.get());
                }
            });
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.shutdownReads();
        } else {
            this.state |= 4;
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        if (!Bits.anyAreSet(this.state, 1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (!Bits.anyAreSet(this.state, 1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void close() throws IOException {
        if (Bits.allAreSet(this.state, 8)) {
            return;
        }
        this.state |= 8;
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.close();
        }
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 8);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public StreamSourceChannel getChannel() {
        return Bits.allAreSet(this.state, 1) ? this.delegate : this;
    }
}

