/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Configuration {
    private Map<String, Set<String>> hostsPerServer = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<String>> hostsPerContainer = new ConcurrentHashMap<String, Set<String>>();

    public Map<String, Set<String>> getHostsPerServer() {
        return this.hostsPerServer;
    }

    public Map<String, Set<String>> getHostsPerContainer() {
        return this.hostsPerContainer;
    }

    public void addContainerHost(String containerId, String serverUrl) {
        Set<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts == null) {
            hosts = new LinkedHashSet<String>();
            this.hostsPerContainer.put(containerId, hosts);
        }
        hosts.add(serverUrl);
    }

    public void addServerHost(String serverId, String serverUrl) {
        Set<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts == null) {
            hosts = new LinkedHashSet<String>();
            this.hostsPerServer.put(serverId, hosts);
        }
        hosts.add(serverUrl);
    }

    public void removeContainerHost(String containerId, String serverUrl) {
        Set<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
    }

    public void removeServerHost(String serverId, String serverUrl) {
        Set<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
    }

    public String toString() {
        return "{hostsPerServer=" + this.hostsPerServer + ", hostsPerContainer=" + this.hostsPerContainer + "}";
    }
}

