/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import org.jboss.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.handlers.ContainersHttpHandler;
import org.kie.server.router.handlers.DocumentsHttpHandler;
import org.kie.server.router.handlers.JobsHttpHandler;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.handlers.QueriesDataHttpHandler;
import org.kie.server.router.handlers.QueriesHttpHandler;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.utils.HttpUtils;

public class KieServerRouter {
    private static final String HOST = System.getProperty("org.kie.server.router.host", "localhost");
    private static final String PORT = System.getProperty("org.kie.server.router.port", "9000");
    private static final String CONTROLLER = System.getProperty("org.kie.server.controller");
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private static final String SERVER_INFO_JSON = "{\n      \"version\" : \"LATEST\",\n      \"name\" : \"KIE Server Router\",\n      \"location\" : \"" + KieServerInfoHandler.getLocationUrl() + "\",\n      \"capabilities\" : [ \"KieServer\", \"BRM\", \"BPM\", \"CaseMgmt\", \"BPM-UI\", \"BRP\" ],\n      \"id\" : \"kie-server-router\"\n}";
    private Undertow server;
    private FileRepository repository = new FileRepository();

    public static void main(String[] args) {
        final KieServerRouter router = new KieServerRouter();
        router.start(HOST, Integer.parseInt(PORT));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                router.stop();
            }
        });
    }

    public void start(String host, Integer port) {
        System.setProperty("org.kie.server.router.host", host);
        System.setProperty("org.kie.server.router.port", port.toString());
        KieServerProxyClient proxyClient = new KieServerProxyClient();
        ResponseCodeHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;
        AdminHttpHandler adminHandler = new AdminHttpHandler(proxyClient, this.repository);
        PathHandler pathHandler = Handlers.path(new ProxyHandler(proxyClient, notFoundHandler));
        pathHandler.addPrefixPath("/queries/definitions", new QueriesDataHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/queries", new QueriesHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/jobs", new JobsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/documents", new DocumentsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addExactPath("/containers", new ContainersHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/admin", adminHandler);
        pathHandler.addExactPath("/", new KieServerInfoHandler());
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(pathHandler).build();
        this.server.start();
        log.infof("KieServerRouter started on %s:%s at %s", (Object)host, (Object)port, (Object)new Date());
        this.connectToController(adminHandler);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean clean) {
        this.disconnectToController();
        if (this.server != null) {
            this.server.stop();
            if (clean) {
                this.repository.clean();
            }
            log.infof("KieServerRouter stopped on %s:%s at %s", (Object)System.getProperty("org.kie.server.router.host"), (Object)System.getProperty("org.kie.server.router.port"), (Object)new Date());
        } else {
            log.error("KieServerRouter was not started");
        }
    }

    protected void connectToController(AdminHttpHandler adminHandler) {
        if (CONTROLLER == null) {
            return;
        }
        try {
            String jsonResponse = HttpUtils.putHttpCall(CONTROLLER + "/server/kie-server-router", SERVER_INFO_JSON);
            log.debugf("Controller response :: ", (Object)jsonResponse);
            ArrayList<String> containers = new ArrayList<String>();
            JSONObject serverConfig = new JSONObject(jsonResponse);
            JSONArray sourceList = serverConfig.getJSONArray("containers");
            for (int i = 0; i < sourceList.length(); ++i) {
                JSONObject container = sourceList.getJSONObject(i);
                containers.add(container.getString("container-id"));
            }
            adminHandler.addControllerContainers(containers);
            log.infof("KieServerRouter connected to controller at " + CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when connecting to controller at " + CONTROLLER), e);
        }
    }

    protected void disconnectToController() {
        if (CONTROLLER == null) {
            return;
        }
        try {
            HttpUtils.deleteHttpCall(CONTROLLER + "/server/kie-server-router/?location=" + URLEncoder.encode(KieServerInfoHandler.getLocationUrl(), "UTF-8"));
            log.infof("KieServerRouter disconnected from controller at " + CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when disconnecting from controller at " + CONTROLLER), e);
        }
    }
}

