/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.kie.server.router.Configuration;

public class ConfigurationMarshaller {
    public String marshall(Configuration configuration) throws Exception {
        JSONArray array;
        Map<String, Set<String>> perContainer = configuration.getHostsPerContainer();
        Map<String, Set<String>> perServer = configuration.getHostsPerServer();
        JSONArray servers = new JSONArray();
        JSONArray containers = new JSONArray();
        JSONObject config = new JSONObject();
        for (Map.Entry<String, Set<String>> entry : perContainer.entrySet()) {
            array = new JSONArray();
            entry.getValue().forEach(url -> array.put(url));
            JSONObject container = new JSONObject();
            container.put(entry.getKey(), array);
            containers.put(container);
        }
        for (Map.Entry<String, Set<String>> entry : perServer.entrySet()) {
            array = new JSONArray();
            entry.getValue().forEach(url -> array.put(url));
            JSONObject server = new JSONObject();
            server.put(entry.getKey(), array);
            servers.put(server);
        }
        config.put("containers", containers);
        config.put("servers", servers);
        return config.toString(2);
    }

    public Configuration unmarshall(Reader reader) throws Exception {
        Configuration configuration = new Configuration();
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject config = new JSONObject(tokener);
        JSONArray containers = config.getJSONArray("containers");
        for (int i = 0; i < containers.length(); ++i) {
            String[] names;
            JSONObject container = (JSONObject)containers.get(i);
            for (String name : names = JSONObject.getNames(container)) {
                JSONArray urls = (JSONArray)container.get(name);
                for (int j = 0; j < urls.length(); ++j) {
                    String url = urls.get(j).toString();
                    configuration.addContainerHost(name, url);
                }
            }
        }
        JSONArray servers = config.getJSONArray("servers");
        for (int i = 0; i < servers.length(); ++i) {
            String[] names;
            JSONObject server = (JSONObject)servers.get(i);
            for (String name : names = JSONObject.getNames(server)) {
                JSONArray urls = (JSONArray)server.get(name);
                for (int j = 0; j < urls.length(); ++j) {
                    String url = urls.get(j).toString();
                    configuration.addServerHost(name, url);
                }
            }
        }
        return configuration;
    }
}

