/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.NullRunnable;
import org.jboss.threads.Version;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;
import org.jboss.threads.management.StandardThreadPoolMXBean;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import sun.misc.Contended;

@Contended
public final class EnhancedQueueExecutor
extends AbstractExecutorService
implements ManageableThreadPoolExecutorService {
    public static final boolean DISABLE_HINT;
    static final boolean UPDATE_TAIL;
    static final boolean UPDATE_STATISTICS;
    static final boolean NO_QUEUE_LIMIT;
    static final boolean SPIN_YIELD;
    static final boolean TAIL_LOCK;
    static final boolean REGISTER_MBEAN;
    static final Executor DEFAULT_HANDLER;
    final Object tailLock = new Object();
    private final ThreadFactory threadFactory;
    private final Runnable terminationTask;
    private final Set<Thread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MXBeanImpl mxBean;
    private final ObjectInstance handle;
    private final AccessControlContext acc;
    @NotNull
    volatile TaskNode head;
    @NotNull
    volatile TaskNode tail;
    volatile long queueSize;
    volatile long threadStatus;
    volatile long timeoutNanos;
    volatile float growthResistance;
    volatile Executor handoffExecutor;
    volatile Thread.UncaughtExceptionHandler exceptionHandler;
    volatile int peakThreadCount;
    volatile int peakQueueSize;
    private final LongAdder submittedTaskCounter = new LongAdder();
    private final LongAdder completedTaskCounter = new LongAdder();
    private final LongAdder rejectedTaskCounter = new LongAdder();
    volatile int activeCount;
    private static final AtomicReferenceFieldUpdater<EnhancedQueueExecutor, TaskNode> headUpdater;
    private static final AtomicReferenceFieldUpdater<EnhancedQueueExecutor, TaskNode> tailUpdater;
    private static final AtomicLongFieldUpdater<EnhancedQueueExecutor> queueSizeUpdater;
    private static final AtomicLongFieldUpdater<EnhancedQueueExecutor> threadStatusUpdater;
    private static final AtomicIntegerFieldUpdater<EnhancedQueueExecutor> peakThreadCountUpdater;
    private static final AtomicIntegerFieldUpdater<EnhancedQueueExecutor> activeCountUpdater;
    private static final AtomicIntegerFieldUpdater<EnhancedQueueExecutor> peakQueueSizeUpdater;
    private static final long TS_THREAD_CNT_MASK = 1048575L;
    private static final long TS_CURRENT_SHIFT = 0L;
    private static final long TS_CORE_SHIFT = 20L;
    private static final long TS_MAX_SHIFT = 40L;
    private static final long TS_ALLOW_CORE_TIMEOUT = 0x1000000000000000L;
    private static final long TS_SHUTDOWN_REQUESTED = 0x2000000000000000L;
    private static final long TS_SHUTDOWN_INTERRUPT = 0x4000000000000000L;
    private static final long TS_SHUTDOWN_COMPLETE = Long.MIN_VALUE;
    static final QNode TERMINATE_COMPLETE;
    static final Runnable WAITING;
    static final Runnable GAVE_UP;
    static final Runnable ACCEPTED;
    static final Runnable EXIT;
    static final AtomicInteger sequence;

    EnhancedQueueExecutor(Builder builder) {
        this.acc = AccessController.getContext();
        int maxSize = builder.getMaximumPoolSize();
        int coreSize = Math.min(builder.getCorePoolSize(), maxSize);
        this.handoffExecutor = builder.getHandoffExecutor();
        this.exceptionHandler = builder.getExceptionHandler();
        this.threadFactory = builder.getThreadFactory();
        this.terminationTask = builder.getTerminationTask();
        this.growthResistance = builder.getGrowthResistance();
        long keepAliveTime = builder.getKeepAliveTime(TimeUnit.NANOSECONDS);
        this.head = this.tail = new TaskNode(null, this.completedTaskCounter);
        this.threadStatus = EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(EnhancedQueueExecutor.withAllowCoreTimeout(0L, builder.allowsCoreThreadTimeOut()), maxSize), coreSize);
        this.timeoutNanos = Math.max(1L, keepAliveTime);
        this.queueSize = EnhancedQueueExecutor.withMaxQueueSize(EnhancedQueueExecutor.withCurrentQueueSize(0L, 0), builder.getMaximumQueueSize());
        this.mxBean = new MXBeanImpl();
        if (builder.isRegisterMBean()) {
            String configuredName = builder.getMBeanName();
            final String finalName = configuredName != null ? configuredName : "threadpool-" + sequence.getAndIncrement();
            this.handle = AccessController.doPrivileged(new PrivilegedAction<ObjectInstance>(){

                @Override
                public ObjectInstance run() {
                    try {
                        return ManagementFactory.getPlatformMBeanServer().registerMBean(EnhancedQueueExecutor.this.mxBean, new ObjectName("jboss.threads", "name", finalName));
                    }
                    catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
                        return null;
                    }
                }
            }, this.acc);
        } else {
            this.handle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        if (TAIL_LOCK && !Thread.holdsLock(this.tailLock)) {
            Object object = this.tailLock;
            synchronized (object) {
                this.execute(runnable);
                return;
            }
        }
        Assert.checkNotNullParam("runnable", runnable);
        TaskNode tail = this.tail;
        while (true) {
            QNode tailNext;
            if ((tailNext = tail.getNext()) instanceof TaskNode) {
                TaskNode tailNextTaskNode;
                while ((tailNext = (tail = (tailNextTaskNode = (TaskNode)tailNext)).getNext()) instanceof TaskNode) {
                }
                if (UPDATE_TAIL) {
                    this.compareAndSetTail(tail, tailNextTaskNode);
                }
            }
            assert (!(tailNext instanceof TaskNode));
            if (tailNext instanceof PoolThreadNode) {
                PoolThreadNode consumerNode;
                QNode tailNextNext = tailNext.getNext();
                if (tail.compareAndSetNext(tailNext, tailNextNext) && (consumerNode = (PoolThreadNode)tailNext).compareAndSetTask(WAITING, runnable)) {
                    if (UPDATE_STATISTICS) {
                        this.submittedTaskCounter.increment();
                    }
                    LockSupport.unpark(consumerNode.getThread());
                    return;
                }
                tail = this.tail;
            } else if (tailNext == null) {
                if (this.tryCreateThreadForTask(runnable, this.growthResistance)) {
                    return;
                }
                if (!NO_QUEUE_LIMIT && !this.increaseQueueSize()) {
                    if (this.tryCreateThreadForTask(runnable, 0.0f)) {
                        return;
                    }
                    if (UPDATE_STATISTICS) {
                        this.rejectedTaskCounter.increment();
                    }
                    this.rejectQueueFull(runnable);
                    return;
                }
                TaskNode node = new TaskNode(runnable, this.completedTaskCounter);
                if (tail.compareAndSetNext(null, node)) {
                    this.compareAndSetTail(tail, node);
                    if (UPDATE_STATISTICS) {
                        this.submittedTaskCounter.increment();
                    }
                    if (EnhancedQueueExecutor.currentSizeOf(this.threadStatus) == 0) {
                        this.tryCreateThreadForTask(null, 0.0f);
                    }
                    return;
                }
                if (!NO_QUEUE_LIMIT) {
                    this.decreaseQueueSize();
                }
                tail = this.tail;
            } else {
                assert (tailNext instanceof TerminateWaiterNode);
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectShutdown(runnable);
                return;
            }
            if (!SPIN_YIELD) continue;
            Thread.yield();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        QNode headNext;
        this.shutdown(true);
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        TaskNode head = this.head;
        while ((headNext = head.getNext()) instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)headNext;
            if (!this.compareAndSetHead(head, taskNode)) continue;
            if (!NO_QUEUE_LIMIT) {
                this.decreaseQueueSize();
            }
            head = taskNode;
            list.add(taskNode.task);
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return EnhancedQueueExecutor.isShutdownRequested(this.threadStatus);
    }

    @Override
    public boolean isTerminated() {
        return EnhancedQueueExecutor.isShutdownComplete(this.threadStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Assert.checkMinimumParameter("timeout", 0L, timeout);
        Assert.checkNotNullParam("unit", unit);
        if (timeout > 0L) {
            TerminateWaiterNode node = new TerminateWaiterNode(Thread.currentThread());
            QNode tail = this.tail;
            while (true) {
                QNode tailNext;
                if ((tailNext = tail.getNext()) == null) {
                    if (!tail.compareAndSetNext(null, node)) continue;
                    break;
                }
                if (tailNext == TERMINATE_COMPLETE) {
                    return true;
                }
                if (UPDATE_TAIL && tailNext instanceof TaskNode) {
                    assert (tail instanceof TaskNode);
                    this.compareAndSetTail((TaskNode)tail, (TaskNode)tailNext);
                }
                tail = tailNext;
            }
            try {
                LockSupport.parkNanos(this, unit.toNanos(timeout));
            }
            finally {
                node.getAndClearThread();
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.isTerminated();
    }

    @Override
    public StandardThreadPoolMXBean getThreadPoolMXBean() {
        return this.mxBean;
    }

    public void shutdown(boolean interrupt) {
        long newStatus;
        long oldStatus;
        block16: {
            do {
                oldStatus = this.threadStatus;
                newStatus = EnhancedQueueExecutor.withShutdownRequested(oldStatus);
                if (interrupt) {
                    newStatus = EnhancedQueueExecutor.withShutdownInterrupt(newStatus);
                }
                if (EnhancedQueueExecutor.currentSizeOf(oldStatus) == 0) {
                    newStatus = EnhancedQueueExecutor.withShutdownComplete(newStatus);
                }
                if (newStatus != oldStatus) continue;
                return;
            } while (!this.compareAndSetThreadStatus(oldStatus, newStatus));
            assert (oldStatus != newStatus);
            if (EnhancedQueueExecutor.isShutdownRequested(newStatus) != EnhancedQueueExecutor.isShutdownRequested(oldStatus)) {
                QNode tailNext;
                block15: {
                    PoolThreadNode node;
                    assert (!EnhancedQueueExecutor.isShutdownRequested(oldStatus));
                    TaskNode tail = this.tail;
                    TerminateWaiterNode terminateNode = new TerminateWaiterNode(null);
                    while (true) {
                        if ((tailNext = tail.getNext()) instanceof TaskNode) {
                            tail = (TaskNode)tailNext;
                            continue;
                        }
                        if (!(tailNext instanceof PoolThreadNode) && tailNext != null) break block15;
                        node = (PoolThreadNode)tailNext;
                        if (tail.compareAndSetNext(node, terminateNode)) break;
                    }
                    while (node != null) {
                        node.compareAndSetTask(WAITING, EXIT);
                        LockSupport.unpark(node.thread);
                        node = node.getNext();
                    }
                    break block16;
                }
                if (!(tailNext instanceof TerminateWaiterNode)) {
                    throw Assert.unreachableCode();
                }
            }
        }
        if (EnhancedQueueExecutor.isShutdownInterrupt(newStatus) != EnhancedQueueExecutor.isShutdownInterrupt(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownInterrupt(oldStatus));
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
            }
        }
        if (EnhancedQueueExecutor.isShutdownComplete(newStatus) != EnhancedQueueExecutor.isShutdownComplete(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownComplete(oldStatus));
            this.completeTermination();
        }
    }

    public boolean isTerminating() {
        long threadStatus = this.threadStatus;
        return EnhancedQueueExecutor.isShutdownRequested(threadStatus) && !EnhancedQueueExecutor.isShutdownComplete(threadStatus);
    }

    public boolean prestartCoreThread() {
        try {
            return this.tryCreateThreadForTask(null, 1.0f);
        }
        catch (RejectedExecutionException ignored) {
            return false;
        }
    }

    public int prestartAllCoreThreads() {
        int cnt = 0;
        while (this.prestartCoreThread()) {
            ++cnt;
        }
        return cnt;
    }

    public float getGrowthResistance() {
        return this.growthResistance;
    }

    public void setGrowthResistance(float growthResistance) {
        Assert.checkMinimumParameter("growthResistance", 0.0f, growthResistance);
        Assert.checkMaximumParameter("growthResistance", 1.0f, growthResistance);
        this.growthResistance = growthResistance;
    }

    public int getCorePoolSize() {
        return EnhancedQueueExecutor.coreSizeOf(this.threadStatus);
    }

    public void setCorePoolSize(int corePoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter("corePoolSize", 0, corePoolSize);
        Assert.checkMaximumParameter("corePoolSize", 1048575L, (long)corePoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = corePoolSize > EnhancedQueueExecutor.maxSizeOf(oldVal = this.threadStatus) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, corePoolSize), corePoolSize) : EnhancedQueueExecutor.withCoreSize(oldVal, corePoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public int getMaximumPoolSize() {
        return EnhancedQueueExecutor.maxSizeOf(this.threadStatus);
    }

    public void setMaximumPoolSize(int maxPoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter("maxPoolSize", 0, maxPoolSize);
        Assert.checkMaximumParameter("maxPoolSize", 1048575L, (long)maxPoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = maxPoolSize < EnhancedQueueExecutor.coreSizeOf(oldVal = this.threadStatus) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize), maxPoolSize) : EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public boolean allowsCoreThreadTimeOut() {
        return EnhancedQueueExecutor.isAllowCoreTimeout(this.threadStatus);
    }

    public void allowCoreThreadTimeOut(boolean value) {
        long newVal;
        long oldVal;
        do {
            if ((oldVal = this.threadStatus) != (newVal = EnhancedQueueExecutor.withAllowCoreTimeout(oldVal, value))) continue;
            return;
        } while (!this.compareAndSetThreadStatus(oldVal, newVal));
        if (value) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public long getKeepAliveTime(TimeUnit keepAliveUnits) {
        Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
        return keepAliveUnits.convert(this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
        Assert.checkMinimumParameter("keepAliveTime", 1L, keepAliveTime);
        Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
        this.timeoutNanos = Math.max(1L, keepAliveUnits.toNanos(keepAliveTime));
    }

    public int getMaximumQueueSize() {
        return EnhancedQueueExecutor.maxQueueSizeOf(this.queueSize);
    }

    public void setMaximumQueueSize(int maxQueueSize) {
        long oldVal;
        Assert.checkMinimumParameter("maxQueueSize", 0, maxQueueSize);
        Assert.checkMaximumParameter("maxQueueSize", Integer.MAX_VALUE, maxQueueSize);
        if (NO_QUEUE_LIMIT) {
            return;
        }
        while (!this.compareAndSetQueueSize(oldVal = this.queueSize, EnhancedQueueExecutor.withMaxQueueSize(oldVal, maxQueueSize))) {
        }
    }

    public Executor getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(Executor handoffExecutor) {
        Assert.checkNotNullParam("handoffExecutor", handoffExecutor);
        this.handoffExecutor = handoffExecutor;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        Assert.checkNotNullParam("exceptionHandler", exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    public int getQueueSize() {
        return EnhancedQueueExecutor.currentQueueSizeOf(this.queueSize);
    }

    public int getLargestPoolSize() {
        return this.peakThreadCount;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getLargestQueueSize() {
        return this.peakQueueSize;
    }

    public long getSubmittedTaskCount() {
        return this.submittedTaskCounter.longValue();
    }

    public long getRejectedTaskCount() {
        return this.rejectedTaskCounter.longValue();
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCounter.longValue();
    }

    public int getPoolSize() {
        return EnhancedQueueExecutor.currentSizeOf(this.threadStatus);
    }

    boolean tryCreateThreadForTask(final Runnable runnable, float growthResistance) throws RejectedExecutionException {
        int oldSize;
        int newSize;
        long oldStat;
        do {
            if (EnhancedQueueExecutor.isShutdownRequested(oldStat = this.threadStatus)) {
                if (UPDATE_STATISTICS && runnable != null) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectShutdown(runnable);
                return true;
            }
            oldSize = EnhancedQueueExecutor.currentSizeOf(oldStat);
            if (oldSize >= EnhancedQueueExecutor.maxSizeOf(oldStat)) {
                return false;
            }
            if (oldSize < EnhancedQueueExecutor.coreSizeOf(oldStat) || oldSize <= 0 || growthResistance == 0.0f || growthResistance != 1.0f && !(ThreadLocalRandom.current().nextFloat() < growthResistance)) continue;
            return false;
        } while (!this.compareAndSetThreadStatus(oldStat, EnhancedQueueExecutor.withCurrentSize(oldStat, newSize = oldSize + 1)));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                boolean ok = false;
                try {
                    Thread thread;
                    try {
                        thread = EnhancedQueueExecutor.this.threadFactory.newThread(new ThreadBody(runnable));
                    }
                    catch (Throwable t) {
                        if (UPDATE_STATISTICS && runnable != null) {
                            EnhancedQueueExecutor.this.rejectedTaskCounter.increment();
                        }
                        EnhancedQueueExecutor.this.rejectException(runnable, t);
                        Void void_ = null;
                        if (!ok) {
                            long oldStat;
                            while (!EnhancedQueueExecutor.this.compareAndSetThreadStatus(oldStat = EnhancedQueueExecutor.this.threadStatus, EnhancedQueueExecutor.withCurrentSize(oldStat, EnhancedQueueExecutor.currentSizeOf(oldStat) - 1))) {
                            }
                        }
                        return void_;
                    }
                    if (thread == null) {
                        if (UPDATE_STATISTICS && runnable != null) {
                            EnhancedQueueExecutor.this.rejectedTaskCounter.increment();
                        }
                        EnhancedQueueExecutor.this.rejectNoThread(runnable);
                        Void t = null;
                        return t;
                    }
                    try {
                        thread.start();
                    }
                    catch (Throwable t) {
                        if (UPDATE_STATISTICS && runnable != null) {
                            EnhancedQueueExecutor.this.rejectedTaskCounter.increment();
                        }
                        EnhancedQueueExecutor.this.rejectException(runnable, t);
                        Void oldStat = null;
                        if (!ok) {
                            long oldStat2;
                            while (!EnhancedQueueExecutor.this.compareAndSetThreadStatus(oldStat2 = EnhancedQueueExecutor.this.threadStatus, EnhancedQueueExecutor.withCurrentSize(oldStat2, EnhancedQueueExecutor.currentSizeOf(oldStat2) - 1))) {
                            }
                        }
                        return oldStat;
                    }
                    ok = true;
                    if (UPDATE_STATISTICS) {
                        int oldVal;
                        EnhancedQueueExecutor.this.submittedTaskCounter.increment();
                        while ((oldVal = EnhancedQueueExecutor.this.peakThreadCount) < newSize && !EnhancedQueueExecutor.this.compareAndSetPeakThreadCount(oldVal, newSize)) {
                        }
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    if (!ok) {
                        long oldStat;
                        while (!EnhancedQueueExecutor.this.compareAndSetThreadStatus(oldStat = EnhancedQueueExecutor.this.threadStatus, EnhancedQueueExecutor.withCurrentSize(oldStat, EnhancedQueueExecutor.currentSizeOf(oldStat) - 1))) {
                        }
                    }
                }
            }
        }, this.acc);
        return true;
    }

    void completeTermination() {
        Thread.interrupted();
        this.safeRun(this.terminationTask);
        TaskNode tail = this.tail;
        for (QNode tailNext = tail.getAndSetNext(TERMINATE_COMPLETE); tailNext != null; tailNext = tailNext.getNext()) {
            if (!(tailNext instanceof TerminateWaiterNode)) continue;
            LockSupport.unpark(((TerminateWaiterNode)tailNext).getAndClearThread());
        }
        final ObjectInstance handle = this.handle;
        if (handle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        ManagementFactory.getPlatformMBeanServer().unregisterMBean(handle.getObjectName());
                    }
                    catch (SecurityException | InstanceNotFoundException | MBeanRegistrationException exception) {
                        // empty catch block
                    }
                    return null;
                }
            }, this.acc);
        }
    }

    void incrementActiveCount() {
        activeCountUpdater.incrementAndGet(this);
    }

    void decrementActiveCount() {
        activeCountUpdater.decrementAndGet(this);
    }

    boolean compareAndSetThreadStatus(long expect, long update) {
        return threadStatusUpdater.compareAndSet(this, expect, update);
    }

    boolean compareAndSetHead(TaskNode expect, TaskNode update) {
        return headUpdater.compareAndSet(this, expect, update);
    }

    boolean compareAndSetPeakThreadCount(int expect, int update) {
        return peakThreadCountUpdater.compareAndSet(this, expect, update);
    }

    boolean compareAndSetPeakQueueSize(int expect, int update) {
        return peakQueueSizeUpdater.compareAndSet(this, expect, update);
    }

    boolean compareAndSetQueueSize(long expect, long update) {
        return queueSizeUpdater.compareAndSet(this, expect, update);
    }

    void compareAndSetTail(TaskNode expect, TaskNode update) {
        tailUpdater.compareAndSet(this, expect, update);
    }

    boolean increaseQueueSize() {
        int oldSize;
        int newSize;
        long oldVal;
        do {
            if ((oldSize = EnhancedQueueExecutor.currentQueueSizeOf(oldVal = this.queueSize)) < EnhancedQueueExecutor.maxQueueSizeOf(oldVal)) continue;
            return false;
        } while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, newSize = oldSize + 1)));
        if (UPDATE_STATISTICS) {
            while (newSize > (oldSize = this.peakQueueSize) && !this.compareAndSetPeakQueueSize(oldSize, newSize)) {
            }
        }
        return true;
    }

    void decreaseQueueSize() {
        long oldVal;
        do {
            oldVal = this.queueSize;
            assert (EnhancedQueueExecutor.currentQueueSizeOf(oldVal) > 0);
        } while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, EnhancedQueueExecutor.currentQueueSizeOf(oldVal) - 1)));
    }

    static int currentQueueSizeOf(long queueSize) {
        return (int)(queueSize & Integer.MAX_VALUE);
    }

    static long withCurrentQueueSize(long queueSize, int current) {
        assert (current >= 0);
        return queueSize & 0xFFFFFFFF00000000L | (long)current;
    }

    static int maxQueueSizeOf(long queueSize) {
        return (int)(queueSize >>> 32 & Integer.MAX_VALUE);
    }

    static long withMaxQueueSize(long queueSize, int max) {
        assert (max >= 0);
        return queueSize & 0xFFFFFFFFL | (long)max << 32;
    }

    static int coreSizeOf(long status) {
        return (int)(status >>> 20 & 0xFFFFFL);
    }

    static int maxSizeOf(long status) {
        return (int)(status >>> 40 & 0xFFFFFL);
    }

    static int currentSizeOf(long status) {
        return (int)(status >>> 0 & 0xFFFFFL);
    }

    static long withCoreSize(long status, int newCoreSize) {
        assert (0 <= newCoreSize && (long)newCoreSize <= 1048575L);
        return status & 0xFFFFFF00000FFFFFL | (long)newCoreSize << 20;
    }

    static long withCurrentSize(long status, int newCurrentSize) {
        assert (0 <= newCurrentSize && (long)newCurrentSize <= 1048575L);
        return status & 0xFFFFFFFFFFF00000L | (long)newCurrentSize << 0;
    }

    static long withMaxSize(long status, int newMaxSize) {
        assert (0 <= newMaxSize && (long)newMaxSize <= 1048575L);
        return status & 0xF00000FFFFFFFFFFL | (long)newMaxSize << 40;
    }

    static long withShutdownRequested(long status) {
        return status | 0x2000000000000000L;
    }

    static long withShutdownComplete(long status) {
        return status | Long.MIN_VALUE;
    }

    static long withShutdownInterrupt(long status) {
        return status | 0x4000000000000000L;
    }

    static long withAllowCoreTimeout(long status, boolean allowed) {
        return allowed ? status | 0x1000000000000000L : status & 0xEFFFFFFFFFFFFFFFL;
    }

    static boolean isShutdownRequested(long status) {
        return (status & 0x2000000000000000L) != 0L;
    }

    static boolean isShutdownComplete(long status) {
        return (status & Long.MIN_VALUE) != 0L;
    }

    static boolean isShutdownInterrupt(long threadStatus) {
        return (threadStatus & 0x4000000000000000L) != 0L;
    }

    static boolean isAllowCoreTimeout(long oldVal) {
        return (oldVal & 0x1000000000000000L) != 0L;
    }

    private static boolean readBooleanProperty(String name, boolean defVal) {
        return Boolean.parseBoolean(EnhancedQueueExecutor.readProperty(name, Boolean.toString(defVal)));
    }

    private static String readProperty(final String name, final String defVal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return EnhancedQueueExecutor.readPropertyRaw(name, defVal);
                }
            });
        }
        return EnhancedQueueExecutor.readPropertyRaw(name, defVal);
    }

    private static String readPropertyRaw(String name, String defVal) {
        return System.getProperty("jboss.threads.eqe." + name, defVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safeRun(Runnable task) {
        try {
            if (task != null) {
                task.run();
            }
        }
        catch (Throwable t) {
            try {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            Thread.interrupted();
        }
    }

    void rejectException(Runnable task, Throwable cause) {
        try {
            this.handoffExecutor.execute(task);
        }
        catch (Throwable t) {
            t.addSuppressed(cause);
            throw t;
        }
    }

    void rejectNoThread(Runnable task) {
        try {
            this.handoffExecutor.execute(task);
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("No threads available"));
            throw t;
        }
    }

    void rejectQueueFull(Runnable task) {
        try {
            this.handoffExecutor.execute(task);
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Queue is full"));
            throw t;
        }
    }

    void rejectShutdown(Runnable task) {
        try {
            this.handoffExecutor.execute(task);
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Executor is being shut down"));
            throw t;
        }
    }

    static {
        Version.getVersionString();
        DISABLE_HINT = EnhancedQueueExecutor.readBooleanProperty("disable", false);
        UPDATE_TAIL = EnhancedQueueExecutor.readBooleanProperty("update-tail", false);
        UPDATE_STATISTICS = EnhancedQueueExecutor.readBooleanProperty("statistics", true);
        NO_QUEUE_LIMIT = EnhancedQueueExecutor.readBooleanProperty("unlimited-queue", false);
        SPIN_YIELD = EnhancedQueueExecutor.readBooleanProperty("spin-yield", false);
        TAIL_LOCK = EnhancedQueueExecutor.readBooleanProperty("tail-lock", false);
        REGISTER_MBEAN = EnhancedQueueExecutor.readBooleanProperty("register-mbean", true);
        DEFAULT_HANDLER = JBossExecutors.rejectingExecutor();
        headUpdater = AtomicReferenceFieldUpdater.newUpdater(EnhancedQueueExecutor.class, TaskNode.class, "head");
        tailUpdater = AtomicReferenceFieldUpdater.newUpdater(EnhancedQueueExecutor.class, TaskNode.class, "tail");
        queueSizeUpdater = AtomicLongFieldUpdater.newUpdater(EnhancedQueueExecutor.class, "queueSize");
        threadStatusUpdater = AtomicLongFieldUpdater.newUpdater(EnhancedQueueExecutor.class, "threadStatus");
        peakThreadCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EnhancedQueueExecutor.class, "peakThreadCount");
        activeCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EnhancedQueueExecutor.class, "activeCount");
        peakQueueSizeUpdater = AtomicIntegerFieldUpdater.newUpdater(EnhancedQueueExecutor.class, "peakQueueSize");
        TERMINATE_COMPLETE = new TerminateWaiterNode(null);
        WAITING = new NullRunnable();
        GAVE_UP = new NullRunnable();
        ACCEPTED = new NullRunnable();
        EXIT = new NullRunnable();
        sequence = new AtomicInteger(1);
    }

    final class MXBeanImpl
    implements StandardThreadPoolMXBean {
        MXBeanImpl() {
        }

        @Override
        public float getGrowthResistance() {
            return EnhancedQueueExecutor.this.getGrowthResistance();
        }

        @Override
        public void setGrowthResistance(float value) {
            EnhancedQueueExecutor.this.setGrowthResistance(value);
        }

        @Override
        public boolean isGrowthResistanceSupported() {
            return true;
        }

        @Override
        public int getCorePoolSize() {
            return EnhancedQueueExecutor.this.getCorePoolSize();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            EnhancedQueueExecutor.this.setCorePoolSize(corePoolSize);
        }

        @Override
        public boolean isCorePoolSizeSupported() {
            return true;
        }

        @Override
        public boolean prestartCoreThread() {
            return EnhancedQueueExecutor.this.prestartCoreThread();
        }

        @Override
        public int prestartAllCoreThreads() {
            return EnhancedQueueExecutor.this.prestartAllCoreThreads();
        }

        @Override
        public boolean isCoreThreadPrestartSupported() {
            return true;
        }

        @Override
        public int getMaximumPoolSize() {
            return EnhancedQueueExecutor.this.getMaximumPoolSize();
        }

        @Override
        public void setMaximumPoolSize(int maxPoolSize) {
            EnhancedQueueExecutor.this.setMaximumPoolSize(maxPoolSize);
        }

        @Override
        public int getPoolSize() {
            return EnhancedQueueExecutor.this.getPoolSize();
        }

        @Override
        public int getLargestPoolSize() {
            return EnhancedQueueExecutor.this.getLargestPoolSize();
        }

        @Override
        public int getActiveCount() {
            return EnhancedQueueExecutor.this.getActiveCount();
        }

        @Override
        public boolean isAllowCoreThreadTimeOut() {
            return EnhancedQueueExecutor.this.allowsCoreThreadTimeOut();
        }

        @Override
        public void setAllowCoreThreadTimeOut(boolean value) {
            EnhancedQueueExecutor.this.allowCoreThreadTimeOut(value);
        }

        @Override
        public long getKeepAliveTimeSeconds() {
            return EnhancedQueueExecutor.this.getKeepAliveTime(TimeUnit.SECONDS);
        }

        @Override
        public void setKeepAliveTimeSeconds(long seconds) {
            EnhancedQueueExecutor.this.setKeepAliveTime(seconds, TimeUnit.SECONDS);
        }

        @Override
        public int getMaximumQueueSize() {
            return EnhancedQueueExecutor.this.getMaximumQueueSize();
        }

        @Override
        public void setMaximumQueueSize(int size) {
            EnhancedQueueExecutor.this.setMaximumQueueSize(size);
        }

        @Override
        public int getQueueSize() {
            return EnhancedQueueExecutor.this.getQueueSize();
        }

        @Override
        public int getLargestQueueSize() {
            return EnhancedQueueExecutor.this.getLargestQueueSize();
        }

        @Override
        public boolean isQueueBounded() {
            return !NO_QUEUE_LIMIT;
        }

        @Override
        public boolean isQueueSizeModifiable() {
            return !NO_QUEUE_LIMIT;
        }

        @Override
        public boolean isShutdown() {
            return EnhancedQueueExecutor.this.isShutdown();
        }

        @Override
        public boolean isTerminating() {
            return EnhancedQueueExecutor.this.isTerminating();
        }

        @Override
        public boolean isTerminated() {
            return EnhancedQueueExecutor.this.isTerminated();
        }

        @Override
        public long getSubmittedTaskCount() {
            return EnhancedQueueExecutor.this.getSubmittedTaskCount();
        }

        @Override
        public long getRejectedTaskCount() {
            return EnhancedQueueExecutor.this.getRejectedTaskCount();
        }

        @Override
        public long getCompletedTaskCount() {
            return EnhancedQueueExecutor.this.getCompletedTaskCount();
        }
    }

    static final class TaskNode
    extends QNode {
        volatile Runnable task;
        final LongAdder completedTaskCounter;

        TaskNode(Runnable task, LongAdder completedTaskCounter) {
            super(null);
            this.completedTaskCounter = completedTaskCounter;
            this.task = task;
        }

        public Runnable getTask() {
            return this.task;
        }

        public TaskNode setTask(Runnable task) {
            this.task = task;
            return this;
        }
    }

    static final class TerminateWaiterNode
    extends QNode {
        private volatile Thread thread;

        TerminateWaiterNode(Thread thread) {
            super(null);
            this.thread = thread;
        }

        Thread getAndClearThread() {
            try {
                Thread thread = this.thread;
                return thread;
            }
            finally {
                this.thread = null;
            }
        }

        @Override
        TerminateWaiterNode getNext() {
            return (TerminateWaiterNode)super.getNext();
        }
    }

    static final class PoolThreadNode
    extends QNode {
        private final Thread thread;
        private volatile Runnable task;
        private static final AtomicReferenceFieldUpdater<PoolThreadNode, Runnable> taskUpdater = AtomicReferenceFieldUpdater.newUpdater(PoolThreadNode.class, Runnable.class, "task");

        PoolThreadNode(PoolThreadNode next, Thread thread) {
            super(next);
            this.thread = thread;
            this.task = WAITING;
        }

        Thread getThread() {
            return this.thread;
        }

        boolean compareAndSetTask(Runnable expect, Runnable update) {
            return taskUpdater.compareAndSet(this, expect, update);
        }

        Runnable getTask() {
            return taskUpdater.get(this);
        }

        @Override
        PoolThreadNode getNext() {
            return (PoolThreadNode)super.getNext();
        }
    }

    static abstract class QNode {
        private static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");
        private volatile QNode next;

        QNode(QNode next) {
            this.next = next;
        }

        boolean compareAndSetNext(QNode expect, QNode update) {
            return nextUpdater.compareAndSet(this, expect, update);
        }

        QNode getNext() {
            return nextUpdater.get(this);
        }

        QNode getAndSetNext(QNode node) {
            return nextUpdater.getAndSet(this, node);
        }
    }

    final class ThreadBody
    implements Runnable {
        private Runnable initialTask;

        ThreadBody(Runnable initialTask) {
            this.initialTask = initialTask;
        }

        @Override
        public void run() {
            long newVal;
            long oldVal;
            QNode headNext;
            Thread currentThread = Thread.currentThread();
            EnhancedQueueExecutor.this.runningThreads.add(currentThread);
            Runnable initialTask = this.initialTask;
            this.initialTask = null;
            if (initialTask != null) {
                if (UPDATE_STATISTICS) {
                    EnhancedQueueExecutor.this.incrementActiveCount();
                }
                EnhancedQueueExecutor.this.safeRun(initialTask);
                if (UPDATE_STATISTICS) {
                    EnhancedQueueExecutor.this.decrementActiveCount();
                    EnhancedQueueExecutor.this.completedTaskCounter.increment();
                }
            }
            block0: while (true) {
                TaskNode head;
                if ((headNext = (head = EnhancedQueueExecutor.this.head).getNext()) instanceof TaskNode) {
                    TaskNode taskNode = (TaskNode)headNext;
                    if (!EnhancedQueueExecutor.this.compareAndSetHead(head, taskNode)) continue;
                    if (!NO_QUEUE_LIMIT) {
                        EnhancedQueueExecutor.this.decreaseQueueSize();
                    }
                    if (EnhancedQueueExecutor.isShutdownInterrupt(EnhancedQueueExecutor.this.threadStatus)) {
                        currentThread.interrupt();
                    } else {
                        Thread.interrupted();
                    }
                    Runnable task = taskNode.getTask();
                    taskNode.setTask(null);
                    if (task == null) continue;
                    if (UPDATE_STATISTICS) {
                        EnhancedQueueExecutor.this.incrementActiveCount();
                    }
                    EnhancedQueueExecutor.this.safeRun(task);
                    if (!UPDATE_STATISTICS) continue;
                    EnhancedQueueExecutor.this.decrementActiveCount();
                    EnhancedQueueExecutor.this.completedTaskCounter.increment();
                    continue;
                }
                if (!(headNext instanceof PoolThreadNode) && headNext != null) break;
                PoolThreadNode newNode = new PoolThreadNode((PoolThreadNode)headNext, currentThread);
                if (!head.compareAndSetNext(headNext, newNode)) continue;
                long start = System.nanoTime();
                long elapsed = 0L;
                block1: while (true) {
                    Runnable task = newNode.getTask();
                    assert (task != ACCEPTED && task != GAVE_UP);
                    if (task != WAITING && task != EXIT) {
                        if (!newNode.compareAndSetTask(task, ACCEPTED)) continue;
                        if (EnhancedQueueExecutor.isShutdownInterrupt(EnhancedQueueExecutor.this.threadStatus)) {
                            currentThread.interrupt();
                        } else {
                            Thread.interrupted();
                        }
                        if (task == null) continue block0;
                        if (UPDATE_STATISTICS) {
                            EnhancedQueueExecutor.this.incrementActiveCount();
                        }
                        EnhancedQueueExecutor.this.safeRun(task);
                        if (!UPDATE_STATISTICS) continue block0;
                        EnhancedQueueExecutor.this.decrementActiveCount();
                        EnhancedQueueExecutor.this.completedTaskCounter.increment();
                        continue block0;
                    }
                    long timeoutNanos = EnhancedQueueExecutor.this.timeoutNanos;
                    long oldVal2 = EnhancedQueueExecutor.this.threadStatus;
                    if (elapsed >= timeoutNanos || task == EXIT || EnhancedQueueExecutor.currentSizeOf(oldVal2) > EnhancedQueueExecutor.maxSizeOf(oldVal2)) {
                        long newVal2;
                        if (!newNode.compareAndSetTask(task, GAVE_UP)) continue;
                        while (true) {
                            if (task == EXIT || EnhancedQueueExecutor.isShutdownRequested(oldVal2) || EnhancedQueueExecutor.isAllowCoreTimeout(oldVal2) || EnhancedQueueExecutor.currentSizeOf(oldVal2) >= EnhancedQueueExecutor.coreSizeOf(oldVal2)) {
                                newVal2 = EnhancedQueueExecutor.withCurrentSize(oldVal2, EnhancedQueueExecutor.currentSizeOf(oldVal2) - 1);
                                if (EnhancedQueueExecutor.currentSizeOf(newVal2) == 0 && EnhancedQueueExecutor.isShutdownRequested(newVal2)) {
                                    newVal2 = EnhancedQueueExecutor.withShutdownComplete(newVal2);
                                }
                            } else {
                                newNode.compareAndSetTask(GAVE_UP, WAITING);
                                LockSupport.park(EnhancedQueueExecutor.this);
                                Thread.interrupted();
                                elapsed = System.nanoTime() - start;
                                continue block1;
                            }
                            if (EnhancedQueueExecutor.this.compareAndSetThreadStatus(oldVal2, newVal2)) break;
                            oldVal2 = EnhancedQueueExecutor.this.threadStatus;
                        }
                        EnhancedQueueExecutor.this.runningThreads.remove(currentThread);
                        if (EnhancedQueueExecutor.isShutdownComplete(newVal2)) {
                            EnhancedQueueExecutor.this.completeTermination();
                        }
                        return;
                    }
                    assert (task == WAITING);
                    LockSupport.parkNanos(EnhancedQueueExecutor.this, timeoutNanos - elapsed);
                    Thread.interrupted();
                    elapsed = System.nanoTime() - start;
                }
                break;
            }
            assert (headNext instanceof TerminateWaiterNode);
            do {
                oldVal = EnhancedQueueExecutor.this.threadStatus;
                assert (EnhancedQueueExecutor.isShutdownRequested(oldVal));
                newVal = EnhancedQueueExecutor.withCurrentSize(oldVal, EnhancedQueueExecutor.currentSizeOf(oldVal) - 1);
                if (EnhancedQueueExecutor.currentSizeOf(newVal) != 0) continue;
                newVal = EnhancedQueueExecutor.withShutdownComplete(newVal);
            } while (!EnhancedQueueExecutor.this.compareAndSetThreadStatus(oldVal, newVal));
            EnhancedQueueExecutor.this.runningThreads.remove(currentThread);
            if (EnhancedQueueExecutor.isShutdownComplete(newVal)) {
                EnhancedQueueExecutor.this.completeTermination();
            }
        }
    }

    public static final class Builder {
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private Runnable terminationTask = NullRunnable.getInstance();
        private Executor handoffExecutor = DEFAULT_HANDLER;
        private Thread.UncaughtExceptionHandler exceptionHandler = JBossExecutors.loggingExceptionHandler();
        private int coreSize = 16;
        private int maxSize = 64;
        private long keepAliveTime = 30L;
        private TimeUnit keepAliveUnits = TimeUnit.SECONDS;
        private float growthResistance;
        private boolean allowCoreTimeOut;
        private int maxQueueSize = Integer.MAX_VALUE;
        private boolean registerMBean = REGISTER_MBEAN;
        private String mBeanName;

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            Assert.checkNotNullParam("threadFactory", threadFactory);
            this.threadFactory = threadFactory;
            return this;
        }

        public Runnable getTerminationTask() {
            return this.terminationTask;
        }

        public Builder setTerminationTask(Runnable terminationTask) {
            Assert.checkNotNullParam("terminationTask", terminationTask);
            this.terminationTask = terminationTask;
            return this;
        }

        public int getCorePoolSize() {
            return this.coreSize;
        }

        public Builder setCorePoolSize(int coreSize) {
            Assert.checkMinimumParameter("coreSize", 0, coreSize);
            Assert.checkMaximumParameter("coreSize", 1048575L, (long)coreSize);
            this.coreSize = coreSize;
            return this;
        }

        public int getMaximumPoolSize() {
            return this.maxSize;
        }

        public Builder setMaximumPoolSize(int maxSize) {
            Assert.checkMinimumParameter("maxSize", 0, maxSize);
            Assert.checkMaximumParameter("maxSize", 1048575L, (long)maxSize);
            this.maxSize = maxSize;
            return this;
        }

        public long getKeepAliveTime(TimeUnit keepAliveUnits) {
            Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
            return keepAliveUnits.convert(this.keepAliveTime, this.keepAliveUnits);
        }

        public Builder setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
            Assert.checkMinimumParameter("keepAliveTime", 1L, keepAliveTime);
            Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
            this.keepAliveTime = keepAliveTime;
            this.keepAliveUnits = keepAliveUnits;
            return this;
        }

        public float getGrowthResistance() {
            return this.growthResistance;
        }

        public Builder setGrowthResistance(float growthResistance) {
            Assert.checkMinimumParameter("growthResistance", 0.0f, growthResistance);
            Assert.checkMaximumParameter("growthResistance", 1.0f, growthResistance);
            this.growthResistance = growthResistance;
            return this;
        }

        public boolean allowsCoreThreadTimeOut() {
            return this.allowCoreTimeOut;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreTimeOut) {
            this.allowCoreTimeOut = allowCoreTimeOut;
            return this;
        }

        public int getMaximumQueueSize() {
            return this.maxQueueSize;
        }

        public Builder setMaximumQueueSize(int maxQueueSize) {
            Assert.checkMinimumParameter("maxQueueSize", 0, maxQueueSize);
            Assert.checkMaximumParameter("maxQueueSize", Integer.MAX_VALUE, maxQueueSize);
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Executor getHandoffExecutor() {
            return this.handoffExecutor;
        }

        public Builder setHandoffExecutor(Executor handoffExecutor) {
            Assert.checkNotNullParam("handoffExecutor", handoffExecutor);
            this.handoffExecutor = handoffExecutor;
            return this;
        }

        public Thread.UncaughtExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public Builder setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public EnhancedQueueExecutor build() {
            return new EnhancedQueueExecutor(this);
        }

        public boolean isRegisterMBean() {
            return this.registerMBean;
        }

        public Builder setRegisterMBean(boolean registerMBean) {
            this.registerMBean = registerMBean;
            return this;
        }

        public String getMBeanName() {
            return this.mBeanName;
        }

        public Builder setMBeanName(String mBeanName) {
            this.mBeanName = mBeanName;
            return this;
        }
    }
}

