/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.kie.server.router.Configuration;
import org.kie.server.router.repository.ConfigFileWatcher;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.spi.ConfigRepository;

public class FileRepository
implements ConfigRepository {
    private final File repositoryDir;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();
    private Configuration configuration;
    private ConfigFileWatcher watcher;
    private boolean configWatcherEnabled = Boolean.parseBoolean(System.getProperty("org.kie.server.router.config.watcher.enabled", "false"));

    public FileRepository() {
        this(new File(System.getProperty("org.kie.server.router.repo", ".")));
    }

    public FileRepository(File repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(Configuration configuration) {
        FileOutputStream fos = null;
        try {
            File configFile = new File(this.repositoryDir, "kie-server-router.json");
            fos = new FileOutputStream(configFile);
            String config = this.marshaller.marshall(configuration);
            PrintWriter writer = new PrintWriter(fos);
            writer.write(config);
            writer.close();
            configFile.setLastModified(System.currentTimeMillis());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Configuration load() {
        this.configuration = new Configuration();
        File serverStateFile = new File(this.repositoryDir, "kie-server-router.json");
        if (serverStateFile.exists()) {
            try (FileReader reader = new FileReader(serverStateFile);){
                this.configuration = this.marshaller.unmarshall(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.configWatcherEnabled) {
            this.watcher = new ConfigFileWatcher(serverStateFile.getParentFile().getAbsolutePath(), this.marshaller, this.configuration);
            Thread watcherThread = new Thread((Runnable)this.watcher, "Kie Router Config Watch Thread");
            watcherThread.start();
        }
        return this.configuration;
    }

    @Override
    public void clean() {
        this.persist(new Configuration());
    }

    @Override
    public void close() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }
}

