/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class KieServerRouterEnvironment {
    private String routerId;
    private String routerName;
    private String routerHost;
    private Integer port;
    private Integer sslPort;
    private String routerExternalUrl;
    private Boolean tlsEnabled;
    private String keystorePath;
    private String keystorePassword;
    private String keystoreKey;
    private String repositoryDir;
    private String identityProvider;
    private String kieControllerUrl;
    private String kieControllerUser;
    private String kieControllerPwd;
    private String kieControllerToken;
    private Boolean configFileWatcherEnabled;
    private Long configFileWatcherInterval;
    private Long kieControllerAttemptInterval;
    private Integer kieControllerRecoveryAttemptLimit;
    private Boolean managementPassword;

    public KieServerRouterEnvironment() {
        this.reload();
    }

    public void reload() {
        this.loadFromSystemEnv();
        this.loadFromProperties();
        this.tlsEnabled = this.keystorePath != null && !this.keystorePath.isEmpty();
    }

    public void loadFromSystemEnv() {
        this.routerId = System.getProperty("org.kie.server.router.id", "kie-server-router");
        this.routerName = System.getProperty("org.kie.server.router.name", "KIE Server Router");
        this.routerHost = System.getProperty("org.kie.server.router.host", "localhost");
        this.port = Integer.getInteger("org.kie.server.router.port", 9000);
        this.sslPort = Integer.getInteger("org.kie.server.router.tls.port", 9443);
        this.routerExternalUrl = System.getProperty("org.kie.server.router.url.external");
        this.keystorePath = System.getProperty("org.kie.server.router.tls.keystore");
        this.keystorePassword = System.getProperty("org.kie.server.router.tls.keystore.password");
        this.keystoreKey = System.getProperty("org.kie.server.router.tls.keystore.keyalias");
        this.repositoryDir = System.getProperty("org.kie.server.router.repo", ".");
        this.identityProvider = System.getProperty("org.kie.router.identity.provider", "default");
        this.kieControllerUrl = System.getProperty("org.kie.server.controller");
        this.kieControllerUser = System.getProperty("org.kie.server.controller.user", "kieserver");
        this.kieControllerPwd = System.getProperty("org.kie.server.controller.pwd", "kieserver1!");
        this.kieControllerToken = System.getProperty("org.kie.server.controller.token");
        this.configFileWatcherEnabled = Boolean.getBoolean("org.kie.server.router.config.watcher.enabled");
        this.configFileWatcherInterval = Long.getLong("org.kie.server.router.config.watcher.interval", 30000L);
        this.kieControllerAttemptInterval = Long.getLong("org.kie.server.controller.retry.interval", 10L);
        this.kieControllerRecoveryAttemptLimit = Integer.getInteger("org.kie.server.recovery.retry.limit", -1);
        this.managementPassword = Boolean.getBoolean("org.kie.server.router.management.password");
    }

    public void loadFromProperties() {
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(new File(System.getProperty("org.kie.server.router.config.file")));){
            props.load(is);
            this.routerId = (String)props.getOrDefault((Object)"org.kie.server.router.id", this.routerId);
            this.routerName = (String)props.getOrDefault((Object)"org.kie.server.router.name", this.routerName);
            this.routerHost = (String)props.getOrDefault((Object)"org.kie.server.router.host", this.routerHost);
            this.port = props.containsKey("org.kie.server.router.port") ? Integer.parseInt((String)props.get("org.kie.server.router.port")) : this.port;
            this.sslPort = props.containsKey("org.kie.server.router.tls.port") ? Integer.parseInt((String)props.get("org.kie.server.router.tls.port")) : this.sslPort;
            this.routerExternalUrl = (String)props.getOrDefault((Object)"org.kie.server.router.url.external", this.routerExternalUrl);
            this.keystorePath = (String)props.getOrDefault((Object)"org.kie.server.router.tls.keystore", this.keystorePath);
            this.keystorePassword = (String)props.getOrDefault((Object)"org.kie.server.router.tls.keystore.password", this.keystorePassword);
            this.keystoreKey = (String)props.getOrDefault((Object)"org.kie.server.router.tls.keystore.keyalias", this.keystoreKey);
            this.repositoryDir = (String)props.getOrDefault((Object)"org.kie.server.router.repo", this.repositoryDir);
            this.identityProvider = (String)props.getOrDefault((Object)"org.kie.router.identity.provider", this.identityProvider);
            this.kieControllerUrl = (String)props.getOrDefault((Object)"org.kie.server.controller", this.kieControllerUrl);
            this.kieControllerUser = (String)props.getOrDefault((Object)"org.kie.server.controller.user", this.kieControllerUser);
            this.kieControllerPwd = (String)props.getOrDefault((Object)"org.kie.server.controller.pwd", this.kieControllerPwd);
            this.kieControllerToken = (String)props.getOrDefault((Object)"org.kie.server.controller.token", this.kieControllerToken);
            this.configFileWatcherEnabled = props.containsKey("org.kie.server.router.config.watcher.enabled") ? Boolean.parseBoolean((String)props.get("org.kie.server.router.config.watcher.enabled")) : this.configFileWatcherEnabled;
            this.configFileWatcherInterval = props.containsKey("org.kie.server.router.config.watcher.interval") ? Long.parseLong((String)props.get("org.kie.server.router.config.watcher.interval")) : this.configFileWatcherInterval;
            this.kieControllerAttemptInterval = props.containsKey("org.kie.server.controller.retry.interval") ? Long.parseLong((String)props.get("org.kie.server.controller.retry.interval")) : this.kieControllerAttemptInterval;
            this.kieControllerRecoveryAttemptLimit = props.containsKey("org.kie.server.recovery.retry.limit") ? Integer.parseInt((String)props.get("org.kie.server.recovery.retry.limit")) : this.kieControllerRecoveryAttemptLimit;
            this.managementPassword = props.containsKey("org.kie.server.router.management.password") ? Boolean.parseBoolean((String)props.get("org.kie.server.router.management.password")) : this.managementPassword;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRouterId() {
        return this.routerId;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getPort() {
        return this.port;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public String getRouterExternalUrl() {
        if (this.routerExternalUrl == null) {
            StringBuilder sb = new StringBuilder();
            boolean httpEnabled = this.isHttpEnabled();
            if (httpEnabled) {
                sb.append("http://");
            } else {
                sb.append("https://");
            }
            sb.append(this.routerHost);
            sb.append(":");
            if (httpEnabled) {
                sb.append(this.port);
            } else {
                sb.append(this.sslPort);
            }
            this.routerExternalUrl = sb.toString();
        }
        return this.routerExternalUrl;
    }

    public boolean isHttpEnabled() {
        return this.isValidPort(this.port);
    }

    private boolean isValidPort(int port) {
        return port > 0;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public boolean hasKieControllerUrl() {
        return this.kieControllerUrl != null;
    }

    public String getKieControllerUrl() {
        return this.kieControllerUrl;
    }

    public String getKieControllerUser() {
        return this.kieControllerUser;
    }

    public String getKieControllerPwd() {
        return this.kieControllerPwd;
    }

    public boolean hasKieControllerToken() {
        return this.kieControllerToken != null;
    }

    public String getKieControllerToken() {
        return this.kieControllerToken;
    }

    public boolean isConfigFileWatcherEnabled() {
        return this.configFileWatcherEnabled;
    }

    public long getConfigFileWatcherInterval() {
        return this.configFileWatcherInterval;
    }

    public long getKieControllerAttemptInterval() {
        return this.kieControllerAttemptInterval;
    }

    public int getKieControllerRecoveryAttemptLimit() {
        return this.kieControllerRecoveryAttemptLimit;
    }

    public boolean isManagementSecured() {
        return this.managementPassword;
    }
}

