/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.kie.api.task.model.Status;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseStage;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.ConvertUtils;

public class CaseManagementRuntimeDataServiceBase {
    private CaseRuntimeDataService caseRuntimeDataService;
    private IdentityProvider identityProvider;
    private boolean bypassAuthUser = false;

    public CaseManagementRuntimeDataServiceBase(CaseRuntimeDataService caseRuntimeDataService, KieServerRegistry context) {
        this.caseRuntimeDataService = caseRuntimeDataService;
        this.identityProvider = context.getIdentityProvider();
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    protected String getUser(String queryParamUser) {
        if (this.bypassAuthUser) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    public CaseMilestoneList getMilestones(String containerId, String caseId, boolean achievedOnly, Integer page, Integer pageSize) {
        Collection caseMilestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, achievedOnly, ConvertUtils.buildQueryContext(page, pageSize));
        List<CaseMilestone> milestones = ConvertUtils.transformMilestones(caseMilestones);
        CaseMilestoneList milestoneList = new CaseMilestoneList(milestones);
        return milestoneList;
    }

    public CaseStageList getStages(String containerId, String caseId, boolean activeOnly, Integer page, Integer pageSize) {
        Collection caseStageInstances = this.caseRuntimeDataService.getCaseInstanceStages(caseId, activeOnly, ConvertUtils.buildQueryContext(page, pageSize));
        List<CaseStage> caseStages = ConvertUtils.transformStages(caseStageInstances);
        CaseStageList stageList = new CaseStageList(caseStages);
        return stageList;
    }

    public CaseAdHocFragmentList getAdHocFragments(String containerId, String caseId) {
        Collection caseAdHocFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
        List caseAdHoc = caseAdHocFragments.stream().map(adf -> CaseAdHocFragment.builder().name(adf.getName()).type(adf.getType()).build()).collect(Collectors.toList());
        CaseAdHocFragmentList adHocFragmentList = new CaseAdHocFragmentList(caseAdHoc);
        return adHocFragmentList;
    }

    public NodeInstanceList getActiveNodes(String containerId, String caseId, Integer page, Integer pageSize) {
        Collection activeNodeInstances = this.caseRuntimeDataService.getActiveNodesForCase(caseId, ConvertUtils.buildQueryContext(page, pageSize));
        List<NodeInstance> activeNodes = ConvertUtils.transformNodeInstance(activeNodeInstances);
        NodeInstanceList activeNodesList = new NodeInstanceList(activeNodes);
        return activeNodesList;
    }

    public ProcessInstanceList getProcessInstancesForCase(String containerId, String caseId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeStatus(status);
        sort = this.safeProcessInstanceSort(sort);
        Collection processInstanceDescs = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<ProcessInstance> processInstances = ConvertUtils.transformProcessInstance(processInstanceDescs);
        ProcessInstanceList processInstancesList = new ProcessInstanceList(processInstances);
        return processInstancesList;
    }

    public CaseInstanceList getCaseInstancesByContainer(String containerId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesByDeployment(containerId, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesByDefinition(String containerId, String caseDefinitionId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesByDefinition(caseDefinitionId, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesOwnedBy(String owner, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeStatus(status);
        owner = this.getUser(owner);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesOwnedBy(owner, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstances(List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstances(status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseDefinitionList getCaseDefinitionsByContainer(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        sort = this.safeCaseDefinitionSort(sort);
        Collection caseDescs = this.caseRuntimeDataService.getCasesByDeployment(containerId, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseDefinition> cases = ConvertUtils.transformCases(caseDescs);
        CaseDefinitionList caseList = new CaseDefinitionList(cases);
        return caseList;
    }

    public CaseDefinitionList getCaseDefinitions(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection caseDescs = null;
        sort = this.safeCaseDefinitionSort(sort);
        caseDescs = filter != null && !filter.isEmpty() ? this.caseRuntimeDataService.getCases(filter, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : this.caseRuntimeDataService.getCases(ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseDefinition> cases = ConvertUtils.transformCases(caseDescs);
        CaseDefinitionList caseList = new CaseDefinitionList(cases);
        return caseList;
    }

    public CaseDefinition getCaseDefinition(String containerId, String caseDefinitionId) {
        org.jbpm.casemgmt.api.model.CaseDefinition caseDef = this.caseRuntimeDataService.getCase(containerId, caseDefinitionId);
        if (caseDef == null) {
            throw new IllegalStateException("Case definition " + containerId + " : " + caseDefinitionId + " not found");
        }
        CaseDefinition caseDefinition = ConvertUtils.transformCase(caseDef);
        return caseDefinition;
    }

    public TaskSummaryList getCaseTasks(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    public TaskSummaryList getCaseTasksAsBusinessAdmin(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    public TaskSummaryList getCaseTasksAsStakeholder(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    protected List<Integer> safeStatus(List<Integer> status) {
        List<Integer> actualStatus = status;
        if (status == null || status.isEmpty()) {
            actualStatus = new ArrayList<Integer>();
            actualStatus.add(1);
        }
        return actualStatus;
    }

    protected List<Status> safeTaskStatus(List<String> status) {
        ArrayList<Status> actualStatus;
        if (status == null || status.isEmpty()) {
            actualStatus = new ArrayList<Status>();
            actualStatus.add(Status.Ready);
            actualStatus.add(Status.Reserved);
            actualStatus.add(Status.InProgress);
        } else {
            actualStatus = status.stream().map(s -> Status.valueOf((String)s)).collect(Collectors.toList());
        }
        return actualStatus;
    }

    protected String safeCaseInstanceSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "CorrelationKey";
        }
        return actualSort;
    }

    protected String safeTaskSummarySort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "t.id";
        }
        return actualSort;
    }

    protected String safeCaseDefinitionSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "CaseId";
        }
        return actualSort;
    }

    protected String safeProcessInstanceSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "ProcessInstanceId";
        }
        return actualSort;
    }
}

