/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentSortBy;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.server.api.model.cases.CaseComment;
import org.kie.server.api.model.cases.CaseCommentList;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseRoleAssignment;
import org.kie.server.api.model.cases.CaseRoleAssignmentList;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.ConvertUtils;
import org.kie.server.services.casemgmt.locator.ByCaseIdContainerLocator;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseManagementServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(CaseManagementServiceBase.class);
    private IdentityProvider identityProvider;
    private CaseService caseService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;
    private TaskModelFactory taskModelFactory;
    private boolean bypassAuthUser = false;

    public CaseManagementServiceBase(CaseService caseService, CaseRuntimeDataService caseRuntimeDataService, KieServerRegistry context) {
        this.caseService = caseService;
        this.caseRuntimeDataService = caseRuntimeDataService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.identityProvider = context.getIdentityProvider();
        this.context = context;
        this.taskModelFactory = TaskModelProvider.getFactory();
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    protected String getUser(String queryParamUser) {
        if (this.bypassAuthUser) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    public String startCase(String containerId, String caseDefinitionId, String payload, String marshallingType) {
        String caseId;
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator()), caseDefinitionId);
        if (caseDef == null) {
            throw new IllegalStateException("Unable to find case '" + caseDefinitionId + "' in container " + containerId);
        }
        logger.debug("About to unmarshal case file from payload: '{}'", (Object)payload);
        CaseFile caseFile = (CaseFile)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, CaseFile.class);
        if (caseFile == null) {
            logger.debug("Case file not given, starting case without case file");
            caseId = this.caseService.startCase(containerId, caseDefinitionId);
        } else {
            logger.debug("Case file provided {}", (Object)caseFile);
            HashMap roleAssignments = new HashMap();
            if (caseFile.getUserAssignments() != null) {
                caseFile.getUserAssignments().entrySet().stream().forEach(entry -> {
                    OrganizationalEntity cfr_ignored_0 = (OrganizationalEntity)roleAssignments.put(entry.getKey(), this.taskModelFactory.newUser((String)entry.getValue()));
                });
            }
            if (caseFile.getGroupAssignments() != null) {
                caseFile.getGroupAssignments().entrySet().stream().forEach(entry -> {
                    OrganizationalEntity cfr_ignored_0 = (OrganizationalEntity)roleAssignments.put(entry.getKey(), this.taskModelFactory.newGroup((String)entry.getValue()));
                });
            }
            CaseFileInstance caseFileInstance = this.caseService.newCaseFileInstance(containerId, caseDefinitionId, caseFile.getData(), roleAssignments);
            caseId = this.caseService.startCase(containerId, caseDefinitionId, caseFileInstance);
        }
        logger.debug("New case instance started with case id {} for case definition {}", (Object)caseId, (Object)caseDefinitionId);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)caseId);
    }

    public String getCaseInstance(String containerId, String caseId, boolean withData, boolean withRoles, boolean withMilestones, boolean withStages, String marshallingType) {
        org.jbpm.casemgmt.api.model.instance.CaseInstance actualCaseInstance = this.caseService.getCaseInstance(caseId, withData, withRoles, withMilestones, withStages);
        CaseInstance caseInstance = ConvertUtils.transformCaseInstance(actualCaseInstance);
        if (withData) {
            caseInstance.setCaseFile(CaseFile.builder().data(actualCaseInstance.getCaseFile().getData()).build());
        }
        if (withMilestones) {
            caseInstance.setMilestones(ConvertUtils.transformMilestones(actualCaseInstance.getCaseMilestones()));
        }
        if (withStages) {
            caseInstance.setStages(ConvertUtils.transformStages(actualCaseInstance.getCaseStages()));
        }
        if (withRoles) {
            caseInstance.setRoleAssignments(ConvertUtils.transformRoleAssignment(actualCaseInstance.getCaseRoles()));
        }
        logger.debug("About to marshal case instance with id '{}' {}", (Object)caseId, (Object)caseInstance);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)caseInstance, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
    }

    public void cancelCaseInstance(String containerId, String caseId, boolean destroy) {
        if (destroy) {
            logger.debug("Destroying case with id {} inside container {}", (Object)caseId, (Object)containerId);
            this.caseService.destroyCase(caseId);
        } else {
            logger.debug("Canceling case with id {} inside container {}", (Object)caseId, (Object)containerId);
            this.caseService.cancelCase(caseId);
        }
    }

    public void reopenCase(String caseId, String containerId, String caseDefinitionId, String payload, String marshallingType) {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByCaseIdContainerLocator(caseId)), caseDefinitionId);
        if (caseDef == null) {
            throw new IllegalStateException("Unable to find case '" + caseDefinitionId + "' in container " + containerId);
        }
        logger.debug("About to unmarshal data from payload: '{}'", (Object)payload);
        Map data = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        this.caseService.reopenCase(caseId, containerId, caseDefinitionId, data);
        logger.debug("Case {} successfully reopened", (Object)caseId);
    }

    public String getCaseFileData(String containerId, String caseId, String marshallingType) {
        CaseFileInstance caseFileInstance = this.caseService.getCaseFileInstance(caseId);
        Map caseFileData = caseFileInstance.getData();
        logger.debug("About to marshal case file data for case with id '{}' {}", (Object)caseId, (Object)caseFileData);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)caseFileData, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
    }

    public String getCaseFileDataByName(String containerId, String caseId, String name, String marshallingType) {
        CaseFileInstance caseFileInstance = this.caseService.getCaseFileInstance(caseId);
        Object caseFileData = caseFileInstance.getData(name);
        logger.debug("About to marshal case file data (name = {}) for case with id '{}' {}", new Object[]{name, caseId, caseFileData});
        return this.marshallerHelper.marshal(containerId, marshallingType, caseFileData, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
    }

    public void putCaseFileData(String containerId, String caseId, String payload, String marshallingType) {
        logger.debug("About to unmarshal case file data from payload: '{}'", (Object)payload);
        Map caseFileData = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("Unmarshalled case file data {} for case with id '{}'", (Object)caseFileData, (Object)caseId);
        this.caseService.addDataToCaseFile(caseId, caseFileData);
    }

    public void putCaseFileDataByName(String containerId, String caseId, String name, String payload, String marshallingType) {
        logger.debug("About to unmarshal case file data from payload: '{}'", (Object)payload);
        Object caseFileData = this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Object.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("Unmarshalled case file data {} for case with id '{}' will be stored under {}", new Object[]{caseFileData, caseId, name});
        this.caseService.addDataToCaseFile(caseId, name, caseFileData);
    }

    public void removeCaseFileDataByName(String containerId, String caseId, List<String> names) {
        logger.debug("Removing {} variables from case with id '{}'", names, (Object)caseId);
        this.caseService.removeDataFromCaseFile(caseId, names);
    }

    public void addDynamicTask(String containerId, String caseId, String stageId, String payload, String marshallingType) {
        logger.debug("About to unmarshal task specification content from payload: '{}'", (Object)payload);
        Map taskSpecificationMap = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        TaskSpecification taskSpecification = null;
        if (taskSpecificationMap == null || taskSpecificationMap.isEmpty()) {
            throw new IllegalArgumentException("Task specification must be given");
        }
        String nodeType = (String)taskSpecificationMap.get("nodeType");
        if (nodeType != null) {
            logger.debug("Creating dynamic task of typ {} within case {}", (Object)nodeType, (Object)caseId);
            taskSpecification = this.caseService.newTaskSpec(nodeType, (String)taskSpecificationMap.get("name"), (Map)taskSpecificationMap.get("data"));
        } else {
            logger.debug("Creating dynamic user task for case {}", (Object)caseId);
            taskSpecification = this.caseService.newHumanTaskSpec((String)taskSpecificationMap.get("name"), (String)taskSpecificationMap.get("description"), (String)taskSpecificationMap.get("actors"), (String)taskSpecificationMap.get("groups"), (Map)taskSpecificationMap.get("data"));
        }
        logger.debug("Complete task specification is '{}'", (Object)taskSpecification);
        if (stageId != null && !stageId.isEmpty()) {
            logger.debug("Adding dynamic task to stage {} within case {}", (Object)stageId, (Object)caseId);
            this.caseService.addDynamicTaskToStage(caseId, stageId, taskSpecification);
        } else {
            logger.debug("Adding dynamic task to case {}", (Object)caseId);
            this.caseService.addDynamicTask(caseId, taskSpecification);
        }
    }

    public void addDynamicSubprocess(String containerId, String caseId, String stageId, String processId, String payload, String marshallingType) {
        logger.debug("About to unmarshal process data from payload: '{}'", (Object)payload);
        Map subProcessParameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("SubProcess data '{}'", (Object)subProcessParameters);
        if (stageId != null && !stageId.isEmpty()) {
            logger.debug("Adding dynamic subprocess to stage {} within case {}", (Object)stageId, (Object)caseId);
            this.caseService.addDynamicSubprocessToStage(caseId, stageId, processId, subProcessParameters);
        } else {
            logger.debug("Adding dynamic subprocess to case {}", (Object)caseId);
            this.caseService.addDynamicSubprocess(caseId, processId, subProcessParameters);
        }
    }

    public void triggerAdHocNode(String containerId, String caseId, String stageId, String adHocName, String payload, String marshallingType) {
        logger.debug("About to unmarshal task data from payload: '{}'", (Object)payload);
        Map adHocTaskData = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("AdHoc task {} will be triggered with data = {}", (Object)adHocName, (Object)adHocTaskData);
        if (stageId == null || stageId.isEmpty()) {
            this.caseService.triggerAdHocFragment(caseId, adHocName, (Object)adHocTaskData);
        }
    }

    public CaseRoleAssignmentList getRoleAssignment(String containerId, String caseId) {
        Collection caseRoleInstances = this.caseService.getCaseRoleAssignments(caseId);
        logger.debug("Roles assignments for case {} are {}", (Object)caseId, (Object)caseRoleInstances);
        List<CaseRoleAssignment> caseRoles = ConvertUtils.transformRoleAssignment(caseRoleInstances);
        CaseRoleAssignmentList caseRolesList = new CaseRoleAssignmentList(caseRoles);
        return caseRolesList;
    }

    public void assignToRole(String containerId, String caseId, String roleName, String user, String group) {
        User entity = null;
        if (user != null && !user.isEmpty()) {
            entity = this.taskModelFactory.newUser(user);
            logger.debug("Assigning user {} to role {} in case {}", new Object[]{user, roleName, caseId});
            this.caseService.assignToCaseRole(caseId, roleName, (OrganizationalEntity)entity);
        }
        if (group != null && !group.isEmpty()) {
            entity = this.taskModelFactory.newGroup(group);
            logger.debug("Assigning group {} to role {} in case {}", new Object[]{group, roleName, caseId});
            this.caseService.assignToCaseRole(caseId, roleName, (OrganizationalEntity)entity);
        }
    }

    public void removeFromRole(String containerId, String caseId, String roleName, String user, String group) {
        User entity = null;
        if (user != null && !user.isEmpty()) {
            entity = this.taskModelFactory.newUser(user);
            logger.debug("Removing user {} from role {} in case {}", new Object[]{user, roleName, caseId});
            this.caseService.removeFromCaseRole(caseId, roleName, (OrganizationalEntity)entity);
        }
        if (group != null && !group.isEmpty()) {
            entity = this.taskModelFactory.newGroup(group);
            logger.debug("Removing group {} from role {} in case {}", new Object[]{group, roleName, caseId});
            this.caseService.removeFromCaseRole(caseId, roleName, (OrganizationalEntity)entity);
        }
    }

    public void addCommentToCase(String containerId, String caseId, String author, String comment, String marshallingType) {
        author = this.getUser(author);
        String actualComment = (String)this.marshallerHelper.unmarshal(containerId, comment, marshallingType, String.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("Adding comment to case {} by {} with text '{}'", new Object[]{caseId, author, actualComment});
        this.caseService.addCaseComment(caseId, author, actualComment);
    }

    public void updateCommentInCase(String containerId, String caseId, String commentId, String author, String comment, String marshallingType) {
        author = this.getUser(author);
        String actualComment = (String)this.marshallerHelper.unmarshal(containerId, comment, marshallingType, String.class, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
        logger.debug("Updating comment {} in case {} by {} with text '{}'", new Object[]{commentId, caseId, author, actualComment});
        this.caseService.updateCaseComment(caseId, commentId, author, actualComment);
    }

    public void removeCommentFromCase(String containerId, String caseId, String commentId) {
        logger.debug("Removing comment with id {} from case {}", (Object)commentId, (Object)caseId);
        this.caseService.removeCaseComment(caseId, commentId);
    }

    public CaseCommentList getComments(String containerId, String caseId, Integer page, Integer pageSize) {
        return this.getComments(containerId, caseId, null, page, pageSize);
    }

    public CaseCommentList getComments(String containerId, String caseId, String sort, Integer page, Integer pageSize) {
        CommentSortBy sortBy = this.parseCommentSortBy(sort);
        Collection caseComments = this.caseService.getCaseComments(caseId, sortBy, ConvertUtils.buildQueryContext(page, pageSize));
        logger.debug("Comments for case {} are {}", (Object)caseId, (Object)caseComments);
        List<CaseComment> comments = ConvertUtils.transformCaseComments(caseComments);
        CaseCommentList commentsList = new CaseCommentList(comments);
        return commentsList;
    }

    protected CommentSortBy parseCommentSortBy(String sort) {
        if (sort == null || sort.isEmpty()) {
            return CommentSortBy.Date;
        }
        if (sort.equalsIgnoreCase("date")) {
            return CommentSortBy.Date;
        }
        if (sort.equalsIgnoreCase("author")) {
            return CommentSortBy.Author;
        }
        logger.warn("Unexpected sort option for case comments '{}', returning default one - by date");
        return CommentSortBy.Date;
    }
}

