/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.marshal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Wrapped;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;

public class MarshallerHelper {
    private KieServerRegistry registry;
    private Map<MarshallingFormat, Marshaller> serverMarshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();

    public MarshallerHelper(KieServerRegistry registry) {
        this.registry = registry;
    }

    public KieServerRegistry getRegistry() {
        return this.registry;
    }

    public String marshal(String containerId, String marshallingFormat, Object entity) {
        return this.marshal(containerId, marshallingFormat, entity, ContainerLocatorProvider.get().getLocator());
    }

    public String marshal(String containerId, String marshallingFormat, Object entity, ContainerLocator locator) {
        MarshallingFormat format = MarshallerHelper.getFormat(marshallingFormat);
        if (format == null) {
            throw new IllegalArgumentException("Unknown marshalling format " + marshallingFormat);
        }
        KieContainerInstanceImpl containerInstance = this.registry.getContainer(containerId, locator);
        if (containerInstance == null) {
            throw new IllegalArgumentException("No container found for id " + containerId + " .");
        }
        Marshaller marshaller = containerInstance.getMarshaller(format);
        if (marshaller == null) {
            throw new IllegalArgumentException("No marshaller found for format " + format);
        }
        return marshaller.marshall(entity, MarshallingFormat.buildParameters((String)marshallingFormat));
    }

    public String marshal(String marshallingFormat, Object entity) {
        MarshallingFormat format = MarshallerHelper.getFormat(marshallingFormat);
        if (format == null) {
            throw new IllegalArgumentException("Unknown marshalling format " + marshallingFormat);
        }
        Marshaller marshaller = this.serverMarshallers.get(format);
        if (marshaller == null) {
            marshaller = MarshallerFactory.getMarshaller(MarshallerHelper.getExtraClasses(this.registry), (MarshallingFormat)format, (ClassLoader)this.getClass().getClassLoader());
            this.serverMarshallers.put(format, marshaller);
        }
        return marshaller.marshall(entity, MarshallingFormat.buildParameters((String)marshallingFormat));
    }

    public <T> T unmarshal(String containerId, String data, String marshallingFormat, Class<T> unmarshalType) {
        return this.unmarshal(containerId, data, marshallingFormat, unmarshalType, ContainerLocatorProvider.get().getLocator());
    }

    public <T> T unmarshal(String containerId, String data, String marshallingFormat, Class<T> unmarshalType, ContainerLocator locator) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        MarshallingFormat format = MarshallerHelper.getFormat(marshallingFormat);
        KieContainerInstanceImpl containerInstance = this.registry.getContainer(containerId, locator);
        if (containerInstance == null || format == null) {
            throw new IllegalArgumentException("No container found for id " + containerId + " or unknown marshalling format " + marshallingFormat);
        }
        Marshaller marshaller = containerInstance.getMarshaller(format);
        if (marshaller == null) {
            throw new IllegalArgumentException("No marshaller found for format " + format);
        }
        Object instance = marshaller.unmarshall(data, unmarshalType, MarshallingFormat.buildParameters((String)marshallingFormat));
        if (instance instanceof Wrapped) {
            return (T)((Wrapped)instance).unwrap();
        }
        return (T)instance;
    }

    public <T> T unmarshal(String data, String marshallingFormat, Class<T> unmarshalType) {
        Object instance;
        if (data == null || data.isEmpty()) {
            return null;
        }
        MarshallingFormat format = MarshallerHelper.getFormat(marshallingFormat);
        Marshaller marshaller = this.serverMarshallers.get(format);
        if (marshaller == null) {
            marshaller = MarshallerFactory.getMarshaller(MarshallerHelper.getExtraClasses(this.registry), (MarshallingFormat)format, (ClassLoader)this.getClass().getClassLoader());
            this.serverMarshallers.put(format, marshaller);
        }
        if ((instance = marshaller.unmarshall(data, unmarshalType, MarshallingFormat.buildParameters((String)marshallingFormat))) instanceof Wrapped) {
            return (T)((Wrapped)instance).unwrap();
        }
        return (T)instance;
    }

    public static MarshallingFormat getFormat(String descriptor) {
        MarshallingFormat format = MarshallingFormat.fromType((String)descriptor);
        if (format == null) {
            format = MarshallingFormat.valueOf((String)descriptor);
        }
        return format;
    }

    private static Set<Class<?>> getExtraClasses(KieServerRegistry registry) {
        Set<Class<?>> extraClasses = registry != null ? registry.getExtraClasses() : new HashSet();
        return extraClasses;
    }
}

