/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security.adapters;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.kie.server.api.security.SecurityAdapter;
import org.kie.server.services.impl.security.web.CaptureHttpRequestFilter;

public class TomcatSecurityAdapter
implements SecurityAdapter {
    private Class<?> abstractUserClass = null;
    private Class<?> genericPrincipalClass = null;
    private boolean active;

    public TomcatSecurityAdapter() {
        try {
            this.abstractUserClass = Class.forName("org.apache.catalina.users.AbstractUser");
            this.genericPrincipalClass = Class.forName("org.apache.catalina.realm.GenericPrincipal");
            this.active = true;
        }
        catch (Exception e) {
            this.active = false;
        }
    }

    public String getUser(Object ... params) {
        HttpServletRequest request;
        if (this.active && (request = CaptureHttpRequestFilter.getRequest()) != null && request.getUserPrincipal() != null) {
            return request.getUserPrincipal().getName();
        }
        return null;
    }

    public List<String> getRoles(Object ... params) {
        HttpServletRequest request;
        ArrayList<String> proles = new ArrayList<String>();
        if (this.active && (request = CaptureHttpRequestFilter.getRequest()) != null && request.getUserPrincipal() != null) {
            Principal principal = request.getUserPrincipal();
            if (this.abstractUserClass.isAssignableFrom(principal.getClass())) {
                Iterator it = (Iterator)this.invoke(principal, "getRoles");
                while (it.hasNext()) {
                    Principal user = (Principal)it.next();
                    proles.add(user.getName());
                }
            } else if (this.genericPrincipalClass.isAssignableFrom(principal.getClass())) {
                String[] roles = (String[])this.invoke(principal, "getRoles");
                proles.addAll(Arrays.asList(roles));
            }
        }
        return proles;
    }

    protected Object invoke(Object o, String method) {
        try {
            Method m = o.getClass().getDeclaredMethod(method, new Class[0]);
            return m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

