/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.HashSet;
import java.util.Set;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="kie-server")
public class KieServerState {
    private static final Logger logger = LoggerFactory.getLogger(KieServerState.class);
    @XStreamImplicit(itemFieldName="controller")
    private Set<String> controllers = new HashSet<String>();
    private KieServerConfig configuration;
    @XStreamAlias(value="containers")
    @XStreamImplicit
    private Set<KieContainerResource> containers = new HashSet<KieContainerResource>();

    public KieServerState() {
        String defaultController = System.getProperty("org.kie.server.controller");
        if (defaultController != null && !defaultController.trim().isEmpty()) {
            String[] controllerList;
            for (String controller : controllerList = defaultController.split(",")) {
                this.controllers.add(controller.trim());
                logger.info("Added default controller located at {}", (Object)controller);
            }
        }
    }

    public Set<String> getControllers() {
        return this.controllers;
    }

    public void setControllers(Set<String> controllers) {
        this.controllers = controllers;
    }

    public Set<KieContainerResource> getContainers() {
        return this.containers;
    }

    public void setContainers(Set<KieContainerResource> containers) {
        this.containers = containers;
    }

    public KieServerConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KieServerConfig configuration) {
        if (this.configuration != null) {
            for (KieServerConfigItem item : configuration.getConfigItems()) {
                KieServerConfigItem existing = this.configuration.getConfigItem(item.getName());
                if (existing != null) {
                    this.configuration.removeConfigItem(existing);
                }
                configuration.addConfigItem(item);
            }
        } else {
            this.configuration = configuration;
        }
    }
}

