/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage;

import java.io.File;
import java.util.Properties;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;

public class KieServerStateRepositoryUtils {
    private KieServerStateRepositoryUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void populateWithSystemProperties(KieServerConfig config) {
        KieServerStateRepositoryUtils.populateWithProperties(config, System.getProperties());
    }

    public static void populateWithProperties(KieServerConfig config, Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            if (!property.startsWith("org.kie.server") && !property.startsWith("org.kie.executor")) continue;
            KieServerConfigItem configItem = new KieServerConfigItem(property, properties.getProperty(property).replaceAll("^\"|\"$", ""), String.class.getName());
            config.addConfigItem(configItem);
        }
    }

    public static String getFileRepoPath() {
        return KieServerStateRepositoryUtils.getValue("org.kie.server.repo", "KIE_SERVER_REPO", ".");
    }

    public static String getServerId() {
        return KieServerStateRepositoryUtils.getValue("org.kie.server.id", "KIE_SERVER_ID", "kieserver");
    }

    public static File getFileRepoDir() {
        return new File(KieServerStateRepositoryUtils.getFileRepoPath());
    }

    public static File getStateFile() {
        return new File(KieServerStateRepositoryUtils.getFileRepoDir(), KieServerStateRepositoryUtils.getServerId() + ".xml");
    }

    public static String getValue(String propName, String envName, String defaultValue) {
        String value = null;
        if (propName != null) {
            value = KieServerStateRepositoryUtils.trimToNull(System.getProperty(propName));
        }
        if (value == null && envName != null) {
            value = KieServerStateRepositoryUtils.trimToNull(System.getenv(envName));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String trimToNull(String s) {
        if (s != null && (s = s.trim()).isEmpty()) {
            s = null;
        }
        return s;
    }
}

